/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation;

import org.apache.hive.druid.org.apache.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.org.apache.druid.segment.BaseLongColumnValueSelector;

public class LongMaxAggregator
implements Aggregator {
    private final BaseLongColumnValueSelector selector;
    private long max;

    static long combineValues(Object lhs, Object rhs) {
        return Math.max(((Number)lhs).longValue(), ((Number)rhs).longValue());
    }

    public LongMaxAggregator(BaseLongColumnValueSelector selector) {
        this.selector = selector;
        this.max = Long.MIN_VALUE;
    }

    @Override
    public void aggregate() {
        this.max = Math.max(this.max, this.selector.getLong());
    }

    @Override
    public Object get() {
        return this.max;
    }

    @Override
    public float getFloat() {
        return this.max;
    }

    @Override
    public long getLong() {
        return this.max;
    }

    @Override
    public double getDouble() {
        return this.max;
    }

    @Override
    public void close() {
    }
}

