/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation.bloom;

import java.nio.ByteBuffer;
import org.apache.hive.druid.org.apache.druid.query.aggregation.bloom.BaseBloomFilterAggregator;
import org.apache.hive.druid.org.apache.druid.query.filter.BloomKFilter;
import org.apache.hive.druid.org.apache.druid.segment.BaseObjectColumnValueSelector;

class ObjectBloomFilterAggregator
extends BaseBloomFilterAggregator<BaseObjectColumnValueSelector<Object>> {
    ObjectBloomFilterAggregator(BaseObjectColumnValueSelector<Object> selector, int maxNumEntries, boolean onHeap) {
        super(selector, maxNumEntries, onHeap);
    }

    @Override
    void bufferAdd(ByteBuffer buf) {
        Object object = ((BaseObjectColumnValueSelector)this.selector).getObject();
        if (object instanceof ByteBuffer) {
            ByteBuffer other = (ByteBuffer)object;
            BloomKFilter.mergeBloomFilterByteBuffers(buf, buf.position(), other, other.position());
        } else if (object instanceof Long) {
            BloomKFilter.addLong(buf, (Long)object);
        } else if (object instanceof Double) {
            BloomKFilter.addDouble(buf, (Double)object);
        } else if (object instanceof Float) {
            BloomKFilter.addFloat(buf, ((Float)object).floatValue());
        } else if (object instanceof String) {
            BloomKFilter.addString(buf, (String)object);
        } else {
            BloomKFilter.addBytes(buf, null, 0, 0);
        }
    }
}

