/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation.mean;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.hive.druid.com.google.common.primitives.Doubles;

public class DoubleMeanHolder {
    public static final int MAX_INTERMEDIATE_SIZE = 128;
    public static final Comparator<DoubleMeanHolder> COMPARATOR = (o1, o2) -> Doubles.compare(o1.mean(), o2.mean());
    private double sum;
    private long count;

    public DoubleMeanHolder(double sum, long count) {
        this.sum = sum;
        this.count = count;
    }

    public void update(double sum) {
        this.sum += sum;
        ++this.count;
    }

    public DoubleMeanHolder update(DoubleMeanHolder other) {
        this.sum += other.sum;
        this.count += other.count;
        return this;
    }

    public double mean() {
        return this.count == 0L ? 0.0 : this.sum / (double)this.count;
    }

    public byte[] toBytes() {
        ByteBuffer buf = ByteBuffer.allocate(128);
        buf.putDouble(0, this.sum);
        buf.putLong(64, this.count);
        return buf.array();
    }

    public static DoubleMeanHolder fromBytes(byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data);
        return new DoubleMeanHolder(buf.getDouble(0), buf.getLong(64));
    }

    public static void init(ByteBuffer buf, int position) {
        DoubleMeanHolder.writeSum(buf, position, 0.0);
        DoubleMeanHolder.writeCount(buf, position, 0L);
    }

    public static void update(ByteBuffer buf, int position, double sum) {
        DoubleMeanHolder.writeSum(buf, position, DoubleMeanHolder.getSum(buf, position) + sum);
        DoubleMeanHolder.writeCount(buf, position, DoubleMeanHolder.getCount(buf, position) + 1L);
    }

    public static void update(ByteBuffer buf, int position, DoubleMeanHolder other) {
        DoubleMeanHolder.writeSum(buf, position, DoubleMeanHolder.getSum(buf, position) + other.sum);
        DoubleMeanHolder.writeCount(buf, position, DoubleMeanHolder.getCount(buf, position) + other.count);
    }

    public static DoubleMeanHolder get(ByteBuffer buf, int position) {
        return new DoubleMeanHolder(DoubleMeanHolder.getSum(buf, position), DoubleMeanHolder.getCount(buf, position));
    }

    private static void writeSum(ByteBuffer buf, int position, double sum) {
        buf.putDouble(position, sum);
    }

    private static double getSum(ByteBuffer buf, int position) {
        return buf.getDouble(position);
    }

    private static void writeCount(ByteBuffer buf, int position, long count) {
        buf.putLong(position + 64, count);
    }

    private static long getCount(ByteBuffer buf, int position) {
        return buf.getLong(position + 64);
    }

    public static class Serializer
    extends JsonSerializer<DoubleMeanHolder> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Override
        public void serialize(DoubleMeanHolder obj, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeBinary(obj.toBytes());
        }
    }
}

