/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation.post;

import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.org.apache.druid.query.cache.CacheKeyBuilder;

public class FinalizingFieldAccessPostAggregator
implements PostAggregator {
    private final String name;
    private final String fieldName;
    private final Comparator<Object> comparator;
    private final Function<Object, Object> finalizer;

    @JsonCreator
    public FinalizingFieldAccessPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName) {
        this(name, fieldName, null, null);
    }

    private FinalizingFieldAccessPostAggregator(String name, String fieldName, Comparator<Object> comparator, Function<Object, Object> finalizer) {
        this.name = name;
        this.fieldName = fieldName;
        this.comparator = comparator;
        this.finalizer = finalizer;
    }

    @Override
    public Set<String> getDependentFields() {
        return Sets.newHashSet(this.fieldName);
    }

    @Override
    public Comparator getComparator() {
        if (this.comparator == null) {
            throw new UnsupportedOperationException("Not decorated");
        }
        return this.comparator;
    }

    @Override
    public Object compute(Map<String, Object> combinedAggregators) {
        if (this.finalizer == null) {
            throw new UnsupportedOperationException("Not decorated");
        }
        return this.finalizer.apply(combinedAggregators.get(this.fieldName));
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public FinalizingFieldAccessPostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        Comparator theComparator = aggregators != null && aggregators.containsKey(this.fieldName) ? aggregators.get(this.fieldName).getComparator() : Comparators.naturalNullsFirst();
        Function<Object, Object> theFinalizer = aggregators != null && aggregators.containsKey(this.fieldName) ? aggregators.get(this.fieldName)::finalizeComputation : Function.identity();
        return new FinalizingFieldAccessPostAggregator(this.name, this.fieldName, theComparator, theFinalizer);
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(20).appendString(this.fieldName).build();
    }

    public String toString() {
        return "FinalizingFieldAccessPostAggregator{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FinalizingFieldAccessPostAggregator that = (FinalizingFieldAccessPostAggregator)o;
        if (this.fieldName != null ? !this.fieldName.equals(that.fieldName) : that.fieldName != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
        return result;
    }
}

