/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.dimension;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractor;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.hive.druid.org.apache.druid.segment.DimensionSelector;
import org.apache.hive.druid.org.apache.druid.segment.column.ValueType;

public class LookupDimensionSpec
implements DimensionSpec {
    private static final byte CACHE_TYPE_ID = 4;
    @JsonProperty
    private final String dimension;
    @JsonProperty
    private final String outputName;
    @JsonProperty
    private final LookupExtractor lookup;
    @JsonProperty
    private final boolean retainMissingValue;
    @JsonProperty
    @Nullable
    private final String replaceMissingValueWith;
    @JsonProperty
    private final String name;
    @JsonProperty
    private final boolean optimize;
    private final LookupExtractorFactoryContainerProvider lookupExtractorFactoryContainerProvider;

    @JsonCreator
    public LookupDimensionSpec(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="outputName") String outputName, @JsonProperty(value="lookup") LookupExtractor lookup, @JsonProperty(value="retainMissingValue") boolean retainMissingValue, @JsonProperty(value="replaceMissingValueWith") String replaceMissingValueWith, @JsonProperty(value="name") String name, @JsonProperty(value="optimize") Boolean optimize, @JacksonInject LookupExtractorFactoryContainerProvider lookupExtractorFactoryContainerProvider) {
        this.retainMissingValue = retainMissingValue;
        this.optimize = optimize == null ? true : optimize;
        this.replaceMissingValueWith = NullHandling.emptyToNullIfNeeded(replaceMissingValueWith);
        this.dimension = Preconditions.checkNotNull(dimension, "dimension can not be Null");
        this.outputName = Preconditions.checkNotNull(outputName, "outputName can not be Null");
        this.lookupExtractorFactoryContainerProvider = lookupExtractorFactoryContainerProvider;
        this.name = name;
        this.lookup = lookup;
        Preconditions.checkArgument(Strings.isNullOrEmpty(name) ^ lookup == null, "name [%s] and lookup [%s] are mutually exclusive please provide either a name or a lookup", name, lookup);
        if (!Strings.isNullOrEmpty(name)) {
            Preconditions.checkNotNull(this.lookupExtractorFactoryContainerProvider, "The system is not configured to allow for lookups, please read about configuring a lookup manager in the docs");
        }
    }

    @Override
    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @Override
    @JsonProperty
    public String getOutputName() {
        return this.outputName;
    }

    @Override
    public ValueType getOutputType() {
        return ValueType.STRING;
    }

    @JsonProperty
    @Nullable
    public LookupExtractor getLookup() {
        return this.lookup;
    }

    @JsonProperty
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    public ExtractionFn getExtractionFn() {
        LookupExtractor lookupExtractor = Strings.isNullOrEmpty(this.name) ? this.lookup : (LookupExtractor)Preconditions.checkNotNull(this.lookupExtractorFactoryContainerProvider.get(this.name), "Lookup [%s] not found", this.name).getLookupExtractorFactory().get();
        return new LookupExtractionFn(lookupExtractor, this.retainMissingValue, this.replaceMissingValueWith, lookupExtractor.isOneToOne(), this.optimize);
    }

    @Override
    public DimensionSelector decorate(DimensionSelector selector) {
        return selector;
    }

    @Override
    public boolean mustDecorate() {
        return false;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8(this.dimension);
        byte[] dimExtractionFnBytes = Strings.isNullOrEmpty(this.name) ? this.getLookup().getCacheKey() : StringUtils.toUtf8(this.name);
        byte[] outputNameBytes = StringUtils.toUtf8(this.outputName);
        byte[] replaceWithBytes = StringUtils.toUtf8(StringUtils.nullToEmptyNonDruidDataString(this.replaceMissingValueWith));
        return ByteBuffer.allocate(6 + dimensionBytes.length + outputNameBytes.length + dimExtractionFnBytes.length + replaceWithBytes.length).put((byte)4).put(dimensionBytes).put((byte)-1).put(outputNameBytes).put((byte)-1).put(dimExtractionFnBytes).put((byte)-1).put(replaceWithBytes).put((byte)-1).put(this.retainMissingValue ? (byte)1 : 0).array();
    }

    @Override
    public boolean preservesOrdering() {
        return this.getExtractionFn().preservesOrdering();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LookupDimensionSpec)) {
            return false;
        }
        LookupDimensionSpec that = (LookupDimensionSpec)o;
        if (this.retainMissingValue != that.retainMissingValue) {
            return false;
        }
        if (this.optimize != that.optimize) {
            return false;
        }
        if (!this.getDimension().equals(that.getDimension())) {
            return false;
        }
        if (!this.getOutputName().equals(that.getOutputName())) {
            return false;
        }
        if (this.getLookup() != null ? !this.getLookup().equals(that.getLookup()) : that.getLookup() != null) {
            return false;
        }
        if (this.replaceMissingValueWith != null ? !this.replaceMissingValueWith.equals(that.replaceMissingValueWith) : that.replaceMissingValueWith != null) {
            return false;
        }
        return this.getName() != null ? this.getName().equals(that.getName()) : that.getName() == null;
    }

    public int hashCode() {
        int result = this.getDimension().hashCode();
        result = 31 * result + this.getOutputName().hashCode();
        result = 31 * result + (this.getLookup() != null ? this.getLookup().hashCode() : 0);
        result = 31 * result + (this.retainMissingValue ? 1 : 0);
        result = 31 * result + (this.replaceMissingValueWith != null ? this.replaceMissingValueWith.hashCode() : 0);
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        result = 31 * result + (this.optimize ? 1 : 0);
        return result;
    }
}

