/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.expression;

import com.google.inject.Inject;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.math.expr.Expr;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprEval;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.hive.druid.org.apache.druid.query.lookup.RegisteredLookupExtractionFn;

public class LookupExprMacro
implements ExprMacroTable.ExprMacro {
    private final LookupExtractorFactoryContainerProvider lookupExtractorFactoryContainerProvider;

    @Inject
    public LookupExprMacro(LookupExtractorFactoryContainerProvider lookupExtractorFactoryContainerProvider) {
        this.lookupExtractorFactoryContainerProvider = lookupExtractorFactoryContainerProvider;
    }

    @Override
    public String name() {
        return "lookup";
    }

    @Override
    public Expr apply(List<Expr> args) {
        if (args.size() != 2) {
            throw new IAE("Function[%s] must have 2 arguments", this.name());
        }
        Expr arg = args.get(0);
        Expr lookupExpr = args.get(1);
        if (!lookupExpr.isLiteral() || lookupExpr.getLiteralValue() == null) {
            throw new IAE("Function[%s] second argument must be a registered lookup name", this.name());
        }
        String lookupName = lookupExpr.getLiteralValue().toString();
        RegisteredLookupExtractionFn extractionFn = new RegisteredLookupExtractionFn(this.lookupExtractorFactoryContainerProvider, lookupName, false, null, false, null);
        class LookupExpr
        extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
            final /* synthetic */ RegisteredLookupExtractionFn val$extractionFn;

            LookupExpr(Expr arg) {
                this.val$extractionFn = registeredLookupExtractionFn;
                super(arg);
            }

            @Override
            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                return ExprEval.of(this.val$extractionFn.apply(NullHandling.emptyToNullIfNeeded(this.arg.eval(bindings).asString())));
            }

            @Override
            public Expr visit(Expr.Shuttle shuttle) {
                Expr newArg = this.arg.visit(shuttle);
                return shuttle.visit(new LookupExpr(newArg));
            }
        }
        return new LookupExpr(arg);
    }
}

