/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.expression;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.hive.druid.org.apache.druid.math.expr.Expr;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprEval;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.org.apache.druid.query.expression.ExprUtils;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.chrono.ISOChronology;

public class TimestampShiftExprMacro
implements ExprMacroTable.ExprMacro {
    @Override
    public String name() {
        return "timestamp_shift";
    }

    @Override
    public Expr apply(List<Expr> args) {
        if (args.size() < 3 || args.size() > 4) {
            throw new IAE("Function[%s] must have 3 to 4 arguments", this.name());
        }
        if (args.stream().skip(1L).allMatch(Expr::isLiteral)) {
            return new TimestampShiftExpr(args);
        }
        return new TimestampShiftDynamicExpr(args);
    }

    private static PeriodGranularity getGranularity(List<Expr> args, Expr.ObjectBinding bindings) {
        return ExprUtils.toPeriodGranularity(args.get(1), null, args.size() > 3 ? args.get(3) : null, bindings);
    }

    private static int getStep(List<Expr> args, Expr.ObjectBinding bindings) {
        return args.get(2).eval(bindings).asInt();
    }

    private static class TimestampShiftDynamicExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        TimestampShiftDynamicExpr(List<Expr> args) {
            super(args);
        }

        @Override
        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            PeriodGranularity granularity = TimestampShiftExprMacro.getGranularity(this.args, bindings);
            Period period = granularity.getPeriod();
            ISOChronology chronology = ISOChronology.getInstance((DateTimeZone)granularity.getTimeZone());
            int step = TimestampShiftExprMacro.getStep(this.args, bindings);
            return ExprEval.of(chronology.add((ReadablePeriod)period, ((Expr)this.args.get(0)).eval(bindings).asLong(), step));
        }

        @Override
        public Expr visit(Expr.Shuttle shuttle) {
            List<Expr> newArgs = this.args.stream().map(x -> x.visit(shuttle)).collect(Collectors.toList());
            return shuttle.visit(new TimestampShiftDynamicExpr(newArgs));
        }
    }

    private static class TimestampShiftExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        private final Chronology chronology;
        private final Period period;
        private final int step;

        TimestampShiftExpr(List<Expr> args) {
            super(args);
            PeriodGranularity granularity = TimestampShiftExprMacro.getGranularity(args, ExprUtils.nilBindings());
            this.period = granularity.getPeriod();
            this.chronology = ISOChronology.getInstance((DateTimeZone)granularity.getTimeZone());
            this.step = TimestampShiftExprMacro.getStep(args, ExprUtils.nilBindings());
        }

        @Override
        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            return ExprEval.of(this.chronology.add((ReadablePeriod)this.period, ((Expr)this.args.get(0)).eval(bindings).asLong(), this.step));
        }

        @Override
        public Expr visit(Expr.Shuttle shuttle) {
            List<Expr> newArgs = this.args.stream().map(x -> x.visit(shuttle)).collect(Collectors.toList());
            return shuttle.visit(new TimestampShiftExpr(newArgs));
        }
    }
}

