/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.extraction;

import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.query.extraction.DimExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;

public abstract class FunctionalExtraction
extends DimExtractionFn {
    private final boolean retainMissingValue;
    private final String replaceMissingValueWith;
    private final Function<String, String> extractionFunction;
    private final ExtractionFn.ExtractionType extractionType;

    public FunctionalExtraction(final Function<String, String> extractionFunction, boolean retainMissingValue, String replaceMissingValueWith, boolean injective) {
        this.retainMissingValue = retainMissingValue;
        this.replaceMissingValueWith = NullHandling.emptyToNullIfNeeded(replaceMissingValueWith);
        Preconditions.checkArgument(!this.retainMissingValue || this.replaceMissingValueWith == null, "Cannot specify a [replaceMissingValueWith] and set [retainMissingValue] to true");
        this.extractionFunction = this.retainMissingValue ? new Function<String, String>(){

            @Override
            @Nullable
            public String apply(@Nullable String dimValue) {
                String retval = (String)extractionFunction.apply(dimValue);
                return NullHandling.isNullOrEquivalent(retval) ? NullHandling.emptyToNullIfNeeded(dimValue) : retval;
            }
        } : new Function<String, String>(){

            @Override
            @Nullable
            public String apply(@Nullable String dimValue) {
                String retval = NullHandling.emptyToNullIfNeeded((String)extractionFunction.apply(dimValue));
                return retval == null ? FunctionalExtraction.this.replaceMissingValueWith : retval;
            }
        };
        this.extractionType = injective ? ExtractionFn.ExtractionType.ONE_TO_ONE : ExtractionFn.ExtractionType.MANY_TO_ONE;
    }

    public boolean isRetainMissingValue() {
        return this.retainMissingValue;
    }

    public String getReplaceMissingValueWith() {
        return this.replaceMissingValueWith;
    }

    public boolean isInjective() {
        return ExtractionFn.ExtractionType.ONE_TO_ONE.equals((Object)this.getExtractionType());
    }

    @Override
    @Nullable
    public String apply(@Nullable String value) {
        return this.extractionFunction.apply(value);
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return this.extractionType;
    }
}

