/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.extraction;

import com.ibm.icu.text.SimpleDateFormat;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.query.extraction.DimExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;

public class TimeDimExtractionFn
extends DimExtractionFn {
    private final String timeFormat;
    private final String resultFormat;
    private final Supplier<Function<String, String>> fn;
    private final boolean joda;

    @JsonCreator
    public TimeDimExtractionFn(@JsonProperty(value="timeFormat") String timeFormat, @JsonProperty(value="resultFormat") String resultFormat, @JsonProperty(value="joda") boolean joda) {
        Preconditions.checkNotNull(timeFormat, "timeFormat must not be null");
        Preconditions.checkNotNull(resultFormat, "resultFormat must not be null");
        this.joda = joda;
        this.timeFormat = timeFormat;
        this.resultFormat = resultFormat;
        this.fn = this.makeFunctionSupplier();
    }

    private Supplier<Function<String, String>> makeFunctionSupplier() {
        if (this.joda) {
            DateTimes.UtcFormatter parser = DateTimes.wrapFormatter(DateTimeFormat.forPattern((String)this.timeFormat));
            DateTimes.UtcFormatter formatter = DateTimes.wrapFormatter(DateTimeFormat.forPattern((String)this.resultFormat));
            Function<String, String> fn = value -> {
                DateTime date;
                try {
                    date = parser.parse((String)value);
                }
                catch (IllegalArgumentException e) {
                    return value;
                }
                return formatter.print(date);
            };
            return () -> fn;
        }
        ThreadLocal<Function> threadLocal = ThreadLocal.withInitial(() -> {
            SimpleDateFormat parser = new SimpleDateFormat(this.timeFormat, Locale.ENGLISH);
            SimpleDateFormat formatter = new SimpleDateFormat(this.resultFormat, Locale.ENGLISH);
            parser.setLenient(true);
            return value -> {
                Date date;
                try {
                    date = parser.parse(value);
                }
                catch (ParseException e) {
                    return value;
                }
                return formatter.format(date);
            };
        });
        return threadLocal::get;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] timeFormatBytes = StringUtils.toUtf8(this.timeFormat);
        return ByteBuffer.allocate(1 + timeFormatBytes.length).put((byte)0).put(timeFormatBytes).array();
    }

    @Override
    @Nullable
    public String apply(@Nullable String dimValue) {
        if (NullHandling.isNullOrEquivalent(dimValue)) {
            return null;
        }
        return this.fn.get().apply(dimValue);
    }

    @JsonProperty
    public String getTimeFormat() {
        return this.timeFormat;
    }

    @JsonProperty
    public String getResultFormat() {
        return this.resultFormat;
    }

    @JsonProperty
    public boolean isJoda() {
        return this.joda;
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return ExtractionFn.ExtractionType.MANY_TO_ONE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeDimExtractionFn that = (TimeDimExtractionFn)o;
        return this.joda == that.joda && Objects.equals(this.timeFormat, that.timeFormat) && Objects.equals(this.resultFormat, that.resultFormat);
    }

    public int hashCode() {
        return Objects.hash(this.timeFormat, this.resultFormat, this.joda);
    }

    public String toString() {
        return "TimeDimExtractionFn{timeFormat='" + this.timeFormat + '\'' + ", resultFormat='" + this.resultFormat + '\'' + ", joda=" + this.joda + '}';
    }
}

