/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.extraction;

import java.nio.ByteBuffer;
import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.common.guava.GuavaUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class TimeFormatExtractionFn
implements ExtractionFn {
    private final String format;
    private final DateTimeZone tz;
    private final Locale locale;
    private final Granularity granularity;
    private final boolean asMillis;
    private final DateTimeFormatter formatter;

    public TimeFormatExtractionFn(@JsonProperty(value="format") String format, @JsonProperty(value="timeZone") DateTimeZone tz, @JsonProperty(value="locale") String localeString, @JsonProperty(value="granularity") Granularity granularity, @JsonProperty(value="asMillis") boolean asMillis) {
        this.format = format;
        this.tz = tz;
        this.locale = localeString == null ? null : Locale.forLanguageTag(localeString);
        Granularity granularity2 = this.granularity = granularity == null ? Granularities.NONE : granularity;
        if (asMillis && format == null) {
            Preconditions.checkArgument(tz == null, "timeZone requires a format");
            Preconditions.checkArgument(localeString == null, "locale requires a format");
            this.formatter = null;
        } else {
            this.formatter = (format == null ? ISODateTimeFormat.dateTime() : DateTimeFormat.forPattern((String)format)).withZone(tz == null ? DateTimeZone.UTC : tz).withLocale(this.locale);
        }
        this.asMillis = asMillis;
    }

    @JsonProperty
    public DateTimeZone getTimeZone() {
        return this.tz;
    }

    @JsonProperty
    public String getFormat() {
        return this.format;
    }

    @JsonProperty
    public String getLocale() {
        if (this.locale != null) {
            return this.locale.toLanguageTag();
        }
        return null;
    }

    @JsonProperty
    public Granularity getGranularity() {
        return this.granularity;
    }

    @JsonProperty
    public boolean isAsMillis() {
        return this.asMillis;
    }

    @Override
    public byte[] getCacheKey() {
        String tzId = (this.tz == null ? DateTimeZone.UTC : this.tz).getID();
        String localeTag = (this.locale == null ? Locale.getDefault() : this.locale).toLanguageTag();
        byte[] exprBytes = StringUtils.toUtf8(this.format + "\u0001" + tzId + "\u0001" + localeTag);
        byte[] granularityCacheKey = this.granularity.getCacheKey();
        return ByteBuffer.allocate(4 + exprBytes.length + granularityCacheKey.length).put((byte)5).put(exprBytes).put((byte)-1).put(granularityCacheKey).put((byte)-1).put(this.asMillis ? (byte)1 : 0).array();
    }

    @Override
    public String apply(long value) {
        long truncated = this.granularity.bucketStart(DateTimes.utc(value)).getMillis();
        return this.formatter == null ? String.valueOf(truncated) : this.formatter.print(truncated);
    }

    @Override
    @Nullable
    public String apply(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (this.asMillis && value instanceof String) {
            Long theLong = GuavaUtils.tryParseLong((String)value);
            return theLong == null ? this.apply(DateTimes.of((String)value).getMillis()) : this.apply(theLong);
        }
        return this.apply(new DateTime(value, (Chronology)ISOChronology.getInstanceUTC()).getMillis());
    }

    @Override
    @Nullable
    public String apply(@Nullable String value) {
        return this.apply((Object)value);
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return ExtractionFn.ExtractionType.MANY_TO_ONE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeFormatExtractionFn that = (TimeFormatExtractionFn)o;
        if (this.asMillis != that.asMillis) {
            return false;
        }
        if (this.format != null ? !this.format.equals(that.format) : that.format != null) {
            return false;
        }
        if (this.tz != null ? !this.tz.equals((Object)that.tz) : that.tz != null) {
            return false;
        }
        if (this.locale != null ? !this.locale.equals(that.locale) : that.locale != null) {
            return false;
        }
        return this.granularity != null ? this.granularity.equals(that.granularity) : that.granularity == null;
    }

    public int hashCode() {
        int result = this.format != null ? this.format.hashCode() : 0;
        result = 31 * result + (this.tz != null ? this.tz.hashCode() : 0);
        result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
        result = 31 * result + (this.granularity != null ? this.granularity.hashCode() : 0);
        result = 31 * result + (this.asMillis ? 1 : 0);
        return result;
    }

    public String toString() {
        return StringUtils.format("timeFormat(\"%s\", %s, %s, %s, %s)", this.format, this.tz, this.locale, this.granularity, this.asMillis);
    }
}

