/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.org.apache.druid.collections.ReferenceCountingResourceHolder;
import org.apache.hive.druid.org.apache.druid.collections.Releaser;
import org.apache.hive.druid.org.apache.druid.java.util.common.CloseableIterators;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.Closer;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.hive.druid.org.apache.druid.query.AbstractPrioritizedCallable;
import org.apache.hive.druid.org.apache.druid.query.QueryInterruptedException;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.Groupers;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.StreamingMergeSortedGrouper;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.DimensionSelector;
import org.apache.hive.druid.org.apache.druid.segment.ObjectColumnSelector;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnCapabilities;

public class ParallelCombiner<KeyType> {
    private static final int MINIMUM_LEAF_COMBINE_DEGREE = 2;
    private final ReferenceCountingResourceHolder<ByteBuffer> combineBufferHolder;
    private final AggregatorFactory[] combiningFactories;
    private final Grouper.KeySerdeFactory<KeyType> combineKeySerdeFactory;
    private final ListeningExecutorService executor;
    private final Comparator<Grouper.Entry<KeyType>> keyObjComparator;
    private final int concurrencyHint;
    private final int priority;
    private final long queryTimeoutAt;
    private final int intermediateCombineDegree;

    public ParallelCombiner(ReferenceCountingResourceHolder<ByteBuffer> combineBufferHolder, AggregatorFactory[] combiningFactories, Grouper.KeySerdeFactory<KeyType> combineKeySerdeFactory, ListeningExecutorService executor, boolean sortHasNonGroupingFields, int concurrencyHint, int priority, long queryTimeoutAt, int intermediateCombineDegree) {
        this.combineBufferHolder = combineBufferHolder;
        this.combiningFactories = combiningFactories;
        this.combineKeySerdeFactory = combineKeySerdeFactory;
        this.executor = executor;
        this.keyObjComparator = combineKeySerdeFactory.objectComparator(sortHasNonGroupingFields);
        this.concurrencyHint = concurrencyHint;
        this.priority = priority;
        this.intermediateCombineDegree = intermediateCombineDegree;
        this.queryTimeoutAt = queryTimeoutAt;
    }

    public CloseableIterator<Grouper.Entry<KeyType>> combine(List<? extends CloseableIterator<Grouper.Entry<KeyType>>> sortedIterators, List<String> mergedDictionary) {
        Closer closer = Closer.create();
        try {
            ByteBuffer combineBuffer = this.combineBufferHolder.get();
            int minimumRequiredBufferCapacity = StreamingMergeSortedGrouper.requiredBufferCapacity(this.combineKeySerdeFactory.factorizeWithDictionary(mergedDictionary), this.combiningFactories);
            Pair<Integer, Integer> degreeAndNumBuffers = this.findLeafCombineDegreeAndNumBuffers(combineBuffer, minimumRequiredBufferCapacity, this.concurrencyHint, sortedIterators.size());
            int leafCombineDegree = (Integer)degreeAndNumBuffers.lhs;
            int numBuffers = (Integer)degreeAndNumBuffers.rhs;
            int sliceSize = combineBuffer.capacity() / numBuffers;
            Supplier<ByteBuffer> bufferSupplier = ParallelCombiner.createCombineBufferSupplier(combineBuffer, numBuffers, sliceSize);
            Pair<List<CloseableIterator<Grouper.Entry<KeyType>>>, List<Future>> combineIteratorAndFutures = this.buildCombineTree(sortedIterators, bufferSupplier, this.combiningFactories, leafCombineDegree, mergedDictionary);
            CloseableIterator combineIterator = (CloseableIterator)Iterables.getOnlyElement((Iterable)combineIteratorAndFutures.lhs);
            List combineFutures = (List)combineIteratorAndFutures.rhs;
            closer.register(() -> ParallelCombiner.checkCombineFutures(combineFutures));
            return CloseableIterators.wrap(combineIterator, closer);
        }
        catch (Throwable t) {
            try {
                closer.close();
            }
            catch (Throwable t2) {
                t.addSuppressed(t2);
            }
            throw t;
        }
    }

    private static void checkCombineFutures(List<Future> combineFutures) {
        for (Future future : combineFutures) {
            try {
                if (!future.isDone()) {
                    future.cancel(true);
                    continue;
                }
                future.get();
            }
            catch (InterruptedException | CancellationException e) {
                throw new QueryInterruptedException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static Supplier<ByteBuffer> createCombineBufferSupplier(final ByteBuffer combineBuffer, final int numBuffers, final int sliceSize) {
        return new Supplier<ByteBuffer>(){
            private int i = 0;

            @Override
            public ByteBuffer get() {
                if (this.i < numBuffers) {
                    return Groupers.getSlice(combineBuffer, sliceSize, this.i++);
                }
                throw new ISE("Requested number[%d] of buffer slices exceeds the planned one[%d]", this.i++, numBuffers);
            }
        };
    }

    private Pair<Integer, Integer> findLeafCombineDegreeAndNumBuffers(ByteBuffer combineBuffer, int requiredMinimumBufferCapacity, int numAvailableThreads, int numLeafNodes) {
        for (int leafCombineDegree = 2; leafCombineDegree <= numLeafNodes; ++leafCombineDegree) {
            int expectedSliceSize;
            int requiredBufferNum = this.computeRequiredBufferNum(numLeafNodes, leafCombineDegree);
            if (requiredBufferNum > numAvailableThreads || (expectedSliceSize = combineBuffer.capacity() / requiredBufferNum) < requiredMinimumBufferCapacity) continue;
            return Pair.of(leafCombineDegree, requiredBufferNum);
        }
        throw new ISE("Cannot find a proper leaf combine degree for the combining tree. Each node of the combining tree requires a buffer of [%d] bytes. Try increasing druid.processing.buffer.sizeBytes (currently [%d] bytes) for larger buffer or druid.query.groupBy.intermediateCombineDegree for a smaller tree", requiredMinimumBufferCapacity, combineBuffer.capacity());
    }

    private int computeRequiredBufferNum(int numChildNodes, int combineDegree) {
        int numChildrenForLastNode = numChildNodes % combineDegree;
        int numCurLevelNodes = numChildNodes / combineDegree + (numChildrenForLastNode > 1 ? 1 : 0);
        int numChildOfParentNodes = numCurLevelNodes + (numChildrenForLastNode == 1 ? 1 : 0);
        if (numChildOfParentNodes == 1) {
            return numCurLevelNodes;
        }
        return numCurLevelNodes + this.computeRequiredBufferNum(numChildOfParentNodes, this.intermediateCombineDegree);
    }

    private Pair<List<CloseableIterator<Grouper.Entry<KeyType>>>, List<Future>> buildCombineTree(List<? extends CloseableIterator<Grouper.Entry<KeyType>>> childIterators, Supplier<ByteBuffer> bufferSupplier, AggregatorFactory[] combiningFactories, int combineDegree, List<String> dictionary) {
        int numChildLevelIterators = childIterators.size();
        ArrayList<Object> childIteratorsOfNextLevel = new ArrayList<Object>();
        ArrayList combineFutures = new ArrayList();
        for (int i = 0; i < numChildLevelIterators; i += combineDegree) {
            if (i < numChildLevelIterators - 1) {
                List<? extends CloseableIterator<Grouper.Entry<KeyType>>> subIterators = childIterators.subList(i, Math.min(i + combineDegree, numChildLevelIterators));
                Pair<CloseableIterator<Grouper.Entry<KeyType>>, Future> iteratorAndFuture = this.runCombiner(subIterators, bufferSupplier.get(), combiningFactories, dictionary);
                childIteratorsOfNextLevel.add(iteratorAndFuture.lhs);
                combineFutures.add(iteratorAndFuture.rhs);
                continue;
            }
            childIteratorsOfNextLevel.add(childIterators.get(i));
        }
        if (childIteratorsOfNextLevel.size() == 1) {
            return Pair.of(childIteratorsOfNextLevel, combineFutures);
        }
        Pair<List<CloseableIterator<Grouper.Entry<KeyType>>>, List<Future>> parentIteratorsAndFutures = this.buildCombineTree(childIteratorsOfNextLevel, bufferSupplier, combiningFactories, this.intermediateCombineDegree, dictionary);
        combineFutures.addAll((Collection)parentIteratorsAndFutures.rhs);
        return Pair.of(parentIteratorsAndFutures.lhs, combineFutures);
    }

    private Pair<CloseableIterator<Grouper.Entry<KeyType>>, Future> runCombiner(final List<? extends CloseableIterator<Grouper.Entry<KeyType>>> iterators, ByteBuffer combineBuffer, AggregatorFactory[] combiningFactories, List<String> dictionary) {
        final SettableColumnSelectorFactory settableColumnSelectorFactory = new SettableColumnSelectorFactory(combiningFactories);
        final StreamingMergeSortedGrouper<KeyType> grouper = new StreamingMergeSortedGrouper<KeyType>(Suppliers.ofInstance(combineBuffer), this.combineKeySerdeFactory.factorizeWithDictionary(dictionary), settableColumnSelectorFactory, combiningFactories, this.queryTimeoutAt);
        grouper.init();
        ListenableFuture<Void> future = this.executor.submit(new AbstractPrioritizedCallable<Void>(this.priority){

            @Override
            public Void call() {
                try (CloseableIterator mergedIterator = CloseableIterators.mergeSorted(iterators, ParallelCombiner.this.keyObjComparator);
                     Releaser releaser = ParallelCombiner.this.combineBufferHolder.increment();){
                    while (mergedIterator.hasNext()) {
                        Grouper.Entry next = (Grouper.Entry)mergedIterator.next();
                        settableColumnSelectorFactory.set(next.values);
                        grouper.aggregate(next.key);
                        settableColumnSelectorFactory.set(null);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                grouper.finish();
                return null;
            }
        });
        return new Pair<CloseableIterator<Grouper.Entry<KeyType>>, Future>(grouper.iterator(), future);
    }

    private static class SettableColumnSelectorFactory
    implements ColumnSelectorFactory {
        private static final int UNKNOWN_COLUMN_INDEX = -1;
        private final Object2IntMap<String> columnIndexMap;
        @Nullable
        private Object[] values;

        SettableColumnSelectorFactory(AggregatorFactory[] aggregatorFactories) {
            this.columnIndexMap = new Object2IntArrayMap<String>(aggregatorFactories.length);
            this.columnIndexMap.defaultReturnValue(-1);
            for (int i = 0; i < aggregatorFactories.length; ++i) {
                this.columnIndexMap.put(aggregatorFactories[i].getName(), i);
            }
        }

        public void set(@Nullable Object[] values) {
            this.values = values;
        }

        private int checkAndGetColumnIndex(String columnName) {
            int columnIndex = this.columnIndexMap.getInt(columnName);
            Preconditions.checkState(columnIndex != -1, "Cannot find a proper column index for column[%s]", columnName);
            return columnIndex;
        }

        @Override
        public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ColumnValueSelector makeColumnValueSelector(final String columnName) {
            return new ObjectColumnSelector(){

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                }

                @Override
                public Class classOfObject() {
                    return Object.class;
                }

                @Override
                public Object getObject() {
                    return values[this.checkAndGetColumnIndex(columnName)];
                }
            };
        }

        @Override
        public ColumnCapabilities getColumnCapabilities(String column) {
            return null;
        }
    }
}

