/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.groupby.strategy;

import com.google.inject.Inject;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.org.apache.druid.collections.BlockingPool;
import org.apache.hive.druid.org.apache.druid.collections.NonBlockingPool;
import org.apache.hive.druid.org.apache.druid.collections.ReferenceCountingResourceHolder;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Global;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Merging;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Smile;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.collect.Utils;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.LazySequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.org.apache.druid.query.DataSource;
import org.apache.hive.druid.org.apache.druid.query.DruidProcessingConfig;
import org.apache.hive.druid.org.apache.druid.query.InsufficientResourcesException;
import org.apache.hive.druid.org.apache.druid.query.IntervalChunkingQueryRunnerDecorator;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryConfig;
import org.apache.hive.druid.org.apache.druid.query.QueryContexts;
import org.apache.hive.druid.org.apache.druid.query.QueryDataSource;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QueryWatcher;
import org.apache.hive.druid.org.apache.druid.query.ResourceLimitExceededException;
import org.apache.hive.druid.org.apache.druid.query.ResultMergeQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.org.apache.druid.query.context.ResponseContext;
import org.apache.hive.druid.org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQueryQueryToolChest;
import org.apache.hive.druid.org.apache.druid.query.groupby.ResultRow;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.GroupByBinaryFnV2;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.GroupByMergingQueryRunnerV2;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.GroupByQueryEngineV2;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.GroupByRowProcessor;
import org.apache.hive.druid.org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.orderby.NoopLimitSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.resource.GroupByQueryResource;
import org.apache.hive.druid.org.apache.druid.query.groupby.strategy.GroupByStrategy;
import org.apache.hive.druid.org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.org.apache.druid.segment.StorageAdapter;

public class GroupByStrategyV2
implements GroupByStrategy {
    public static final String CTX_KEY_FUDGE_TIMESTAMP = "fudgeTimestamp";
    public static final String CTX_KEY_OUTERMOST = "groupByOutermost";
    private static final int MAX_MERGE_BUFFER_NUM = 2;
    private final DruidProcessingConfig processingConfig;
    private final Supplier<GroupByQueryConfig> configSupplier;
    private final Supplier<QueryConfig> queryConfigSupplier;
    private final NonBlockingPool<ByteBuffer> bufferPool;
    private final BlockingPool<ByteBuffer> mergeBufferPool;
    private final ObjectMapper spillMapper;
    private final QueryWatcher queryWatcher;

    @Inject
    public GroupByStrategyV2(DruidProcessingConfig processingConfig, Supplier<GroupByQueryConfig> configSupplier, Supplier<QueryConfig> queryConfigSupplier, @Global NonBlockingPool<ByteBuffer> bufferPool, @Merging BlockingPool<ByteBuffer> mergeBufferPool, @Smile ObjectMapper spillMapper, QueryWatcher queryWatcher) {
        this.processingConfig = processingConfig;
        this.configSupplier = configSupplier;
        this.queryConfigSupplier = queryConfigSupplier;
        this.bufferPool = bufferPool;
        this.mergeBufferPool = mergeBufferPool;
        this.spillMapper = spillMapper;
        this.queryWatcher = queryWatcher;
    }

    @Override
    public GroupByQueryResource prepareResource(GroupByQuery query) {
        int requiredMergeBufferNum = GroupByStrategyV2.countRequiredMergeBufferNum(query, 1) + this.numMergeBuffersNeededForSubtotalsSpec(query);
        if (requiredMergeBufferNum > this.mergeBufferPool.maxSize()) {
            throw new ResourceLimitExceededException("Query needs " + requiredMergeBufferNum + " merge buffers, but only " + this.mergeBufferPool.maxSize() + " merge buffers were configured", new Object[0]);
        }
        if (requiredMergeBufferNum == 0) {
            return new GroupByQueryResource();
        }
        List<ReferenceCountingResourceHolder<ByteBuffer>> mergeBufferHolders = QueryContexts.hasTimeout(query) ? this.mergeBufferPool.takeBatch(requiredMergeBufferNum, QueryContexts.getTimeout(query)) : this.mergeBufferPool.takeBatch(requiredMergeBufferNum);
        if (mergeBufferHolders.isEmpty()) {
            throw new InsufficientResourcesException("Cannot acquire enough merge buffers");
        }
        return new GroupByQueryResource(mergeBufferHolders);
    }

    private static int countRequiredMergeBufferNum(Query query, int foundNum) {
        DataSource dataSource = query.getDataSource();
        if (foundNum == 3 || !(dataSource instanceof QueryDataSource)) {
            return foundNum - 1;
        }
        return GroupByStrategyV2.countRequiredMergeBufferNum(((QueryDataSource)dataSource).getQuery(), foundNum + 1);
    }

    @Override
    public boolean isCacheable(boolean willMergeRunners) {
        return willMergeRunners;
    }

    @Override
    public boolean doMergeResults(GroupByQuery query) {
        return true;
    }

    @Override
    public QueryRunner<ResultRow> createIntervalChunkingRunner(IntervalChunkingQueryRunnerDecorator decorator, QueryRunner<ResultRow> runner, GroupByQueryQueryToolChest toolChest) {
        return runner;
    }

    @Override
    public Comparator<ResultRow> createResultComparator(Query<ResultRow> queryParam) {
        return ((GroupByQuery)queryParam).getRowOrdering(true);
    }

    @Override
    public BinaryOperator<ResultRow> createMergeFn(Query<ResultRow> queryParam) {
        return new GroupByBinaryFnV2((GroupByQuery)queryParam);
    }

    @Override
    public Sequence<ResultRow> mergeResults(QueryRunner<ResultRow> baseRunner, GroupByQuery query, ResponseContext responseContext) {
        ResultMergeQueryRunner<ResultRow> mergingQueryRunner = new ResultMergeQueryRunner<ResultRow>(baseRunner, this::createResultComparator, this::createMergeFn);
        ImmutableMap.Builder<String, Object> context = ImmutableMap.builder();
        context.put("finalize", false);
        context.put("groupByStrategy", "v2");
        context.put(CTX_KEY_OUTERMOST, false);
        if (query.getUniversalTimestamp() != null) {
            context.put(CTX_KEY_FUDGE_TIMESTAMP, String.valueOf(query.getUniversalTimestamp().getMillis()));
        }
        context.put("applyLimitPushDown", query.isApplyLimitPushDown());
        context.put("resultAsArray", true);
        Query newQuery = new GroupByQuery(query.getDataSource(), query.getQuerySegmentSpec(), query.getVirtualColumns(), query.getDimFilter(), query.getGranularity(), query.getDimensions(), query.getAggregatorSpecs(), query.getPostAggregatorSpecs(), null, query.getLimitSpec(), query.getSubtotalsSpec(), query.getContext()).withOverriddenContext((Map)context.build());
        Sequence<ResultRow> mergedResults = mergingQueryRunner.run(QueryPlus.wrap(newQuery), responseContext);
        if (!query.getContextBoolean(CTX_KEY_OUTERMOST, true) || query.getPostAggregatorSpecs().isEmpty() || query.getContextBoolean("executingNestedQuery", false)) {
            return mergedResults;
        }
        return Sequences.map(mergedResults, row -> {
            ResultRow rowWithPostAggregations = ResultRow.create(query.getResultRowSizeWithPostAggregators());
            for (int i = 0; i < query.getResultRowPostAggregatorStart(); ++i) {
                rowWithPostAggregations.set(i, row.get(i));
            }
            Map<String, Object> mapForPostAggregationComputation = rowWithPostAggregations.toMap(query);
            for (int i = 0; i < query.getPostAggregatorSpecs().size(); ++i) {
                PostAggregator postAggregator = query.getPostAggregatorSpecs().get(i);
                Object value = postAggregator.compute(mapForPostAggregationComputation);
                rowWithPostAggregations.set(query.getResultRowPostAggregatorStart() + i, value);
                mapForPostAggregationComputation.put(postAggregator.getName(), value);
            }
            return rowWithPostAggregations;
        });
    }

    @Override
    public Sequence<ResultRow> applyPostProcessing(Sequence<ResultRow> results, GroupByQuery query) {
        if (query.getContextBoolean(CTX_KEY_OUTERMOST, true)) {
            return query.postProcess(results);
        }
        return results;
    }

    @Override
    public Sequence<ResultRow> processSubqueryResult(GroupByQuery subquery, GroupByQuery query, GroupByQueryResource resource, Sequence<ResultRow> subqueryResult, boolean wasQueryPushedDown) {
        GroupByRowProcessor.ResultSupplier resultSupplier = null;
        try {
            GroupByQuery queryToRun = wasQueryPushedDown ? query.withDimFilter(null).withQuerySegmentSpec(new MultipleIntervalSegmentSpec(Intervals.ONLY_ETERNITY)) : query;
            GroupByRowProcessor.ResultSupplier finalResultSupplier = resultSupplier = GroupByRowProcessor.process(queryToRun, wasQueryPushedDown ? queryToRun : subquery, subqueryResult, this.configSupplier.get(), resource, this.spillMapper, this.processingConfig.getTmpDir(), this.processingConfig.intermediateComputeSizeBytes());
            return Sequences.withBaggage(this.mergeResults((queryPlus, responseContext) -> finalResultSupplier.results(null), query, null), finalResultSupplier);
        }
        catch (Exception ex) {
            CloseQuietly.close(resultSupplier);
            throw ex;
        }
    }

    @Override
    public Sequence<ResultRow> processSubtotalsSpec(GroupByQuery query, GroupByQueryResource resource, Sequence<ResultRow> queryResult) {
        GroupByRowProcessor.ResultSupplier resultSupplierOne = null;
        try {
            GroupByQuery queryWithoutSubtotalsSpec = query.withDimensionSpecs(query.getDimensions().stream().map(dimSpec -> new DefaultDimensionSpec(dimSpec.getOutputName(), dimSpec.getOutputName(), dimSpec.getOutputType())).collect(Collectors.toList())).withAggregatorSpecs(query.getAggregatorSpecs().stream().map(AggregatorFactory::getCombiningFactory).collect(Collectors.toList())).withSubtotalsSpec(null).withDimFilter(null);
            resultSupplierOne = GroupByRowProcessor.process(queryWithoutSubtotalsSpec, queryWithoutSubtotalsSpec, queryResult, this.configSupplier.get(), resource, this.spillMapper, this.processingConfig.getTmpDir(), this.processingConfig.intermediateComputeSizeBytes());
            List queryDimNames = queryWithoutSubtotalsSpec.getDimensions().stream().map(DimensionSpec::getOutputName).collect(Collectors.toList());
            Set<String> aggsAndPostAggs = null;
            if (queryWithoutSubtotalsSpec.getLimitSpec() != null && !(queryWithoutSubtotalsSpec.getLimitSpec() instanceof NoopLimitSpec)) {
                aggsAndPostAggs = this.getAggregatorAndPostAggregatorNames(queryWithoutSubtotalsSpec);
            }
            List<List<String>> subtotals = query.getSubtotalsSpec();
            ArrayList subtotalsResults = new ArrayList(subtotals.size());
            for (List<String> subtotalSpec : subtotals) {
                ImmutableSet<String> dimsInSubtotalSpec = ImmutableSet.copyOf(subtotalSpec);
                List<DimensionSpec> dimensions = query.getDimensions();
                ArrayList<DimensionSpec> newDimensions = new ArrayList<DimensionSpec>();
                for (int i = 0; i < dimensions.size(); ++i) {
                    DimensionSpec dimensionSpec = dimensions.get(i);
                    if (dimsInSubtotalSpec.contains(dimensionSpec.getOutputName())) {
                        newDimensions.add(new DefaultDimensionSpec(dimensionSpec.getOutputName(), dimensionSpec.getOutputName(), dimensionSpec.getOutputType()));
                        continue;
                    }
                    String dimName = "_" + i;
                    while (query.getResultRowPositionLookup().getInt(dimName) >= 0) {
                        dimName = "_" + dimName;
                    }
                    newDimensions.add(DefaultDimensionSpec.of(dimName));
                }
                LimitSpec subtotalQueryLimitSpec = NoopLimitSpec.instance();
                if (queryWithoutSubtotalsSpec.getLimitSpec() != null && !(queryWithoutSubtotalsSpec.getLimitSpec() instanceof NoopLimitSpec)) {
                    HashSet<String> columns = new HashSet<String>(aggsAndPostAggs);
                    columns.addAll(subtotalSpec);
                    subtotalQueryLimitSpec = queryWithoutSubtotalsSpec.getLimitSpec().filterColumns(columns);
                }
                GroupByQuery subtotalQuery = queryWithoutSubtotalsSpec.withLimitSpec(subtotalQueryLimitSpec).withDimensionSpecs(newDimensions);
                GroupByRowProcessor.ResultSupplier resultSupplierOneFinal = resultSupplierOne;
                if (Utils.isPrefix(subtotalSpec, queryDimNames)) {
                    subtotalsResults.add(this.processSubtotalsResultAndOptionallyClose(() -> resultSupplierOneFinal, subtotalSpec, subtotalQuery, false));
                    continue;
                }
                Supplier<GroupByRowProcessor.ResultSupplier> resultSupplierTwo = () -> GroupByRowProcessor.process(queryWithoutSubtotalsSpec, subtotalQuery, resultSupplierOneFinal.results(subtotalSpec), this.configSupplier.get(), resource, this.spillMapper, this.processingConfig.getTmpDir(), this.processingConfig.intermediateComputeSizeBytes());
                subtotalsResults.add(this.processSubtotalsResultAndOptionallyClose(resultSupplierTwo, subtotalSpec, subtotalQuery, true));
            }
            return Sequences.withBaggage(Sequences.concat(subtotalsResults), resultSupplierOne);
        }
        catch (Exception ex) {
            CloseQuietly.close(resultSupplierOne);
            throw ex;
        }
    }

    private Sequence<ResultRow> processSubtotalsResultAndOptionallyClose(Supplier<GroupByRowProcessor.ResultSupplier> baseResultsSupplier, List<String> dimsToInclude, GroupByQuery subtotalQuery, boolean closeOnSequenceRead) {
        try {
            Supplier<GroupByRowProcessor.ResultSupplier> memoizedSupplier = Suppliers.memoize(baseResultsSupplier);
            return this.applyPostProcessing(this.mergeResults((queryPlus, responseContext) -> new LazySequence(() -> Sequences.withBaggage(((GroupByRowProcessor.ResultSupplier)memoizedSupplier.get()).results(dimsToInclude), closeOnSequenceRead ? () -> CloseQuietly.close((Closeable)memoizedSupplier.get()) : () -> {})), subtotalQuery, null), subtotalQuery);
        }
        catch (Exception ex) {
            CloseQuietly.close(baseResultsSupplier.get());
            throw ex;
        }
    }

    private Set<String> getAggregatorAndPostAggregatorNames(GroupByQuery query) {
        HashSet<String> aggsAndPostAggs = new HashSet<String>();
        if (query.getAggregatorSpecs() != null) {
            for (AggregatorFactory af : query.getAggregatorSpecs()) {
                aggsAndPostAggs.add(af.getName());
            }
        }
        if (query.getPostAggregatorSpecs() != null) {
            for (PostAggregator pa : query.getPostAggregatorSpecs()) {
                aggsAndPostAggs.add(pa.getName());
            }
        }
        return aggsAndPostAggs;
    }

    private int numMergeBuffersNeededForSubtotalsSpec(GroupByQuery query) {
        List<List<String>> subtotalSpecs = query.getSubtotalsSpec();
        if (subtotalSpecs == null || subtotalSpecs.size() == 0) {
            return 0;
        }
        List queryDimOutputNames = query.getDimensions().stream().map(DimensionSpec::getOutputName).collect(Collectors.toList());
        for (List<String> subtotalSpec : subtotalSpecs) {
            if (Utils.isPrefix(subtotalSpec, queryDimOutputNames)) continue;
            return 2;
        }
        return 1;
    }

    @Override
    public QueryRunner<ResultRow> mergeRunners(ListeningExecutorService exec, Iterable<QueryRunner<ResultRow>> queryRunners) {
        return new GroupByMergingQueryRunnerV2(this.configSupplier.get(), exec, this.queryWatcher, queryRunners, this.processingConfig.getNumThreads(), this.mergeBufferPool, this.processingConfig.intermediateComputeSizeBytes(), this.spillMapper, this.processingConfig.getTmpDir());
    }

    @Override
    public Sequence<ResultRow> process(GroupByQuery query, StorageAdapter storageAdapter) {
        return GroupByQueryEngineV2.process(query, storageAdapter, this.bufferPool, this.configSupplier.get().withOverrides(query), this.queryConfigSupplier.get().withOverrides(query));
    }

    @Override
    public boolean supportsNestedQueryPushDown() {
        return true;
    }
}

