/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.scan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.UOE;
import org.apache.hive.druid.org.apache.druid.query.scan.ScanQuery;
import org.apache.hive.druid.org.apache.druid.segment.DimensionHandlerUtils;

public class ScanResultValue
implements Comparable<ScanResultValue> {
    private final String segmentId;
    private final List<String> columns;
    private final Object events;

    @JsonCreator
    public ScanResultValue(@JsonProperty(value="segmentId") @Nullable String segmentId, @JsonProperty(value="columns") List<String> columns, @JsonProperty(value="events") Object events) {
        this.segmentId = segmentId;
        this.columns = columns;
        this.events = events;
    }

    @Nullable
    @JsonProperty
    public String getSegmentId() {
        return this.segmentId;
    }

    @JsonProperty
    public List<String> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public Object getEvents() {
        return this.events;
    }

    public long getFirstEventTimestamp(ScanQuery.ResultFormat resultFormat) {
        if (resultFormat.equals((Object)ScanQuery.ResultFormat.RESULT_FORMAT_LIST)) {
            Object timestampObj = ((Map)((List)this.getEvents()).get(0)).get("__time");
            if (timestampObj == null) {
                throw new ISE("Unable to compare timestamp for rows without a time column", new Object[0]);
            }
            return DimensionHandlerUtils.convertObjectToLong(timestampObj);
        }
        if (resultFormat.equals((Object)ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST)) {
            int timeColumnIndex = this.getColumns().indexOf("__time");
            if (timeColumnIndex == -1) {
                throw new ISE("Unable to compare timestamp for rows without a time column", new Object[0]);
            }
            List firstEvent = (List)((List)this.getEvents()).get(0);
            return DimensionHandlerUtils.convertObjectToLong(firstEvent.get(timeColumnIndex));
        }
        throw new UOE("Unable to get first event timestamp using result format of [%s]", resultFormat.toString());
    }

    public List<ScanResultValue> toSingleEventScanResultValues() {
        ArrayList<ScanResultValue> singleEventScanResultValues = new ArrayList<ScanResultValue>();
        List events = (List)this.getEvents();
        for (Object event : events) {
            singleEventScanResultValues.add(new ScanResultValue(this.segmentId, this.columns, Collections.singletonList(event)));
        }
        return singleEventScanResultValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanResultValue that = (ScanResultValue)o;
        if (this.segmentId != null ? !this.segmentId.equals(that.segmentId) : that.segmentId != null) {
            return false;
        }
        if (this.columns != null ? !this.columns.equals(that.columns) : that.columns != null) {
            return false;
        }
        return this.events != null ? this.events.equals(that.events) : that.events == null;
    }

    public int hashCode() {
        int result = this.segmentId != null ? this.segmentId.hashCode() : 0;
        result = 31 * result + (this.columns != null ? this.columns.hashCode() : 0);
        result = 31 * result + (this.events != null ? this.events.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ScanResultValue{segmentId='" + this.segmentId + '\'' + ", columns=" + this.columns + ", events=" + this.events + '}';
    }

    @Override
    public int compareTo(ScanResultValue that) {
        if (that == null) {
            return 1;
        }
        if (this.segmentId != null && that.segmentId != null) {
            return this.segmentId.compareTo(that.segmentId);
        }
        return this.segmentId != null ? 1 : 0;
    }
}

