/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.spec;

import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QuerySegmentWalker;
import org.apache.hive.druid.org.apache.druid.query.SegmentDescriptor;
import org.apache.hive.druid.org.apache.druid.query.spec.QuerySegmentSpec;
import org.joda.time.Interval;

public class SpecificSegmentSpec
implements QuerySegmentSpec {
    private final SegmentDescriptor descriptor;

    public SpecificSegmentSpec(SegmentDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public List<Interval> getIntervals() {
        return Collections.singletonList(this.descriptor.getInterval());
    }

    @Override
    public <T> QueryRunner<T> lookup(Query<T> query, QuerySegmentWalker walker) {
        return walker.getQueryRunnerForSegments(query, Collections.singletonList(this.descriptor));
    }

    public SegmentDescriptor getDescriptor() {
        return this.descriptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpecificSegmentSpec that = (SpecificSegmentSpec)o;
        return !(this.descriptor != null ? !this.descriptor.equals(that.descriptor) : that.descriptor != null);
    }

    public int hashCode() {
        return this.descriptor != null ? this.descriptor.hashCode() : 0;
    }
}

