/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.topn.types;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.hive.druid.org.apache.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.org.apache.druid.query.topn.BaseTopNAlgorithm;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNQuery;
import org.apache.hive.druid.org.apache.druid.query.topn.types.NullableNumericTopNColumnAggregatesProcessor;
import org.apache.hive.druid.org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.Cursor;

public class DoubleTopNColumnAggregatesProcessor
extends NullableNumericTopNColumnAggregatesProcessor<BaseDoubleColumnValueSelector> {
    private Long2ObjectMap<Aggregator[]> aggregatesStore;

    protected DoubleTopNColumnAggregatesProcessor(Function<Object, Comparable<?>> converter) {
        super(converter);
    }

    @Override
    Aggregator[] getValueAggregators(TopNQuery query, BaseDoubleColumnValueSelector selector, Cursor cursor) {
        long key = Double.doubleToLongBits(selector.getDouble());
        return this.aggregatesStore.computeIfAbsent(key, k -> BaseTopNAlgorithm.makeAggregators(cursor, query.getAggregatorSpecs()));
    }

    @Override
    public void initAggregateStore() {
        this.nullValueAggregates = null;
        this.aggregatesStore = new Long2ObjectOpenHashMap<Aggregator[]>();
    }

    @Override
    Map<?, Aggregator[]> getAggregatesStore() {
        return this.aggregatesStore;
    }

    @Override
    Comparable<?> convertAggregatorStoreKeyToColumnValue(Object aggregatorStoreKey) {
        return (Comparable)this.converter.apply(Double.longBitsToDouble((Long)aggregatorStoreKey));
    }
}

