/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment;

import com.ning.compress.BufferRecycler;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.org.apache.druid.collections.NonBlockingPool;
import org.apache.hive.druid.org.apache.druid.collections.ResourceHolder;
import org.apache.hive.druid.org.apache.druid.collections.StupidPool;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;

public class CompressedPools {
    private static final Logger log = new Logger(CompressedPools.class);
    public static final int BUFFER_SIZE = 65536;
    private static final NonBlockingPool<BufferRecycler> BUFFER_RECYCLER_POOL = new StupidPool<BufferRecycler>("bufferRecyclerPool", new Supplier<BufferRecycler>(){
        private final AtomicLong counter = new AtomicLong(0L);

        @Override
        public BufferRecycler get() {
            log.debug("Allocating new bufferRecycler[%,d]", this.counter.incrementAndGet());
            return new BufferRecycler();
        }
    });
    private static final NonBlockingPool<byte[]> OUTPUT_BYTES_POOL = new StupidPool<byte[]>("outputBytesPool", new Supplier<byte[]>(){
        private final AtomicLong counter = new AtomicLong(0L);

        @Override
        public byte[] get() {
            log.debug("Allocating new outputBytesPool[%,d]", this.counter.incrementAndGet());
            return new byte[65536];
        }
    });
    private static final NonBlockingPool<ByteBuffer> BIG_ENDIAN_BYTE_BUF_POOL = new StupidPool<ByteBuffer>("bigEndByteBufPool", new Supplier<ByteBuffer>(){
        private final AtomicLong counter = new AtomicLong(0L);

        @Override
        public ByteBuffer get() {
            log.debug("Allocating new bigEndByteBuf[%,d]", this.counter.incrementAndGet());
            return ByteBuffer.allocateDirect(65536).order(ByteOrder.BIG_ENDIAN);
        }
    });
    private static final NonBlockingPool<ByteBuffer> LITTLE_ENDIAN_BYTE_BUF_POOL = new StupidPool<ByteBuffer>("littleEndByteBufPool", new Supplier<ByteBuffer>(){
        private final AtomicLong counter = new AtomicLong(0L);

        @Override
        public ByteBuffer get() {
            log.debug("Allocating new littleEndByteBuf[%,d]", this.counter.incrementAndGet());
            return ByteBuffer.allocateDirect(65536).order(ByteOrder.LITTLE_ENDIAN);
        }
    });

    public static ResourceHolder<BufferRecycler> getBufferRecycler() {
        return BUFFER_RECYCLER_POOL.take();
    }

    public static ResourceHolder<byte[]> getOutputBytes() {
        return OUTPUT_BYTES_POOL.take();
    }

    public static ResourceHolder<ByteBuffer> getByteBuf(ByteOrder order) {
        if (order == ByteOrder.LITTLE_ENDIAN) {
            return LITTLE_ENDIAN_BYTE_BUF_POOL.take();
        }
        return BIG_ENDIAN_BYTE_BUF_POOL.take();
    }
}

