/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.hive.druid.org.apache.druid.common.utils.SerializerUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.segment.data.CompressedColumnarFloatsSupplier;
import org.apache.hive.druid.org.apache.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.hive.druid.org.apache.druid.segment.serde.ComplexMetrics;

public class MetricHolder {
    private static final byte[] VERSION = new byte[]{0};
    private static final SerializerUtils SERIALIZER_UTILS = new SerializerUtils();
    private final String name;
    private final String typeName;
    private final MetricType type;
    @Nullable
    CompressedColumnarFloatsSupplier floatType = null;
    @Nullable
    GenericIndexed<?> complexType = null;

    public static MetricHolder fromByteBuffer(ByteBuffer buf) {
        byte ver = buf.get();
        if (VERSION[0] != ver) {
            throw new ISE("Unknown version[%s] of MetricHolder", ver);
        }
        String metricName = SERIALIZER_UTILS.readString(buf);
        String typeName = SERIALIZER_UTILS.readString(buf);
        MetricHolder holder = new MetricHolder(metricName, typeName);
        switch (holder.type) {
            case FLOAT: {
                holder.floatType = CompressedColumnarFloatsSupplier.fromByteBuffer(buf, ByteOrder.nativeOrder());
                break;
            }
            case COMPLEX: {
                ComplexMetricSerde serdeForType = ComplexMetrics.getSerdeForType(holder.getTypeName());
                if (serdeForType == null) {
                    throw new ISE("Unknown type[%s], cannot load.", holder.getTypeName());
                }
                holder.complexType = MetricHolder.read(buf, serdeForType);
                break;
            }
            case LONG: 
            case DOUBLE: {
                throw new ISE("Unsupported type[%s]", new Object[]{holder.type});
            }
        }
        return holder;
    }

    private static <T> GenericIndexed<T> read(ByteBuffer buf, ComplexMetricSerde serde) {
        return GenericIndexed.read(buf, serde.getObjectStrategy());
    }

    private MetricHolder(String name, String typeName) {
        this.name = name;
        this.typeName = typeName;
        this.type = MetricType.determineType(typeName);
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public MetricType getType() {
        return this.type;
    }

    public static enum MetricType {
        LONG,
        FLOAT,
        DOUBLE,
        COMPLEX;


        static MetricType determineType(String typeName) {
            if ("long".equalsIgnoreCase(typeName)) {
                return LONG;
            }
            if ("float".equalsIgnoreCase(typeName)) {
                return FLOAT;
            }
            if ("double".equalsIgnoreCase(typeName)) {
                return DOUBLE;
            }
            return COMPLEX;
        }
    }
}

