/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.filter;

import java.util.Set;
import org.apache.hive.druid.org.apache.druid.query.BitmapResultFactory;
import org.apache.hive.druid.org.apache.druid.query.filter.BitmapIndexSelector;
import org.apache.hive.druid.org.apache.druid.query.filter.Filter;
import org.apache.hive.druid.org.apache.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelector;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class NotFilter
implements Filter {
    private final Filter baseFilter;

    public NotFilter(Filter baseFilter) {
        this.baseFilter = baseFilter;
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        return bitmapResultFactory.complement(this.baseFilter.getBitmapResult(selector, bitmapResultFactory), selector.getNumRows());
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        final ValueMatcher baseMatcher = this.baseFilter.makeMatcher(factory);
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return !baseMatcher.matches();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("baseMatcher", baseMatcher);
            }
        };
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(final VectorColumnSelectorFactory factory) {
        final VectorValueMatcher baseMatcher = this.baseFilter.makeVectorMatcher(factory);
        return new BaseVectorValueMatcher(baseMatcher){
            final VectorMatch scratch;
            {
                super(selector);
                this.scratch = VectorMatch.wrap(new int[factory.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask) {
                ReadableVectorMatch baseMatch = baseMatcher.match(mask);
                this.scratch.copyFrom(mask);
                this.scratch.removeAll(baseMatch);
                assert (this.scratch.isValid(mask));
                return this.scratch;
            }
        };
    }

    @Override
    public boolean canVectorizeMatcher() {
        return this.baseFilter.canVectorizeMatcher();
    }

    @Override
    public Set<String> getRequiredColumns() {
        return this.baseFilter.getRequiredColumns();
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return this.baseFilter.supportsBitmapIndex(selector);
    }

    @Override
    public boolean shouldUseBitmapIndex(BitmapIndexSelector selector) {
        return this.baseFilter.shouldUseBitmapIndex(selector);
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        return this.baseFilter.supportsSelectivityEstimation(columnSelector, indexSelector);
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector indexSelector) {
        return 1.0 - this.baseFilter.estimateSelectivity(indexSelector);
    }

    public Filter getBaseFilter() {
        return this.baseFilter;
    }
}

