/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.loading;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.net.URI;
import java.nio.file.Path;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.hive.druid.org.apache.druid.data.SearchableVersionedDataFinder;
import org.apache.hive.druid.org.apache.druid.java.util.common.RetryUtils;
import org.apache.hive.druid.org.apache.druid.segment.loading.LocalDataSegmentPuller;

public class LocalFileTimestampVersionFinder
extends LocalDataSegmentPuller
implements SearchableVersionedDataFinder<URI> {
    public static final String URI_SCHEME = "file";

    private URI mostRecentInDir(Path dir, final Pattern pattern) {
        long latestModified = Long.MIN_VALUE;
        URI latest = null;
        for (File file : dir.toFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.exists() && pathname.isFile() && (pattern == null || pattern.matcher(pathname.getName()).matches());
            }
        })) {
            long thisModified = file.lastModified();
            if (thisModified < latestModified) continue;
            latestModified = thisModified;
            latest = file.toURI();
        }
        return latest;
    }

    @Override
    public URI getLatestVersion(URI uri, @Nullable Pattern pattern) {
        File file = new File(uri);
        try {
            return RetryUtils.retry(() -> this.mostRecentInDir(file.isDirectory() ? file.toPath() : file.getParentFile().toPath(), pattern), this.shouldRetryPredicate(), 3);
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                return null;
            }
            throw new RuntimeException(e);
        }
    }
}

