/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator;

import java.io.Closeable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.druid.client.CachingQueryRunner;
import org.apache.hive.druid.org.apache.druid.client.cache.Cache;
import org.apache.hive.druid.org.apache.druid.client.cache.CacheConfig;
import org.apache.hive.druid.org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.hive.druid.org.apache.druid.client.cache.ForegroundCachePopulator;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.FunctionalIterable;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.query.BySegmentQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.CPUTimeMetricQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.MetricsEmittingQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.NoopQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryMetrics;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerHelper;
import org.apache.hive.druid.org.apache.druid.query.QuerySegmentWalker;
import org.apache.hive.druid.org.apache.druid.query.QueryToolChest;
import org.apache.hive.druid.org.apache.druid.query.ReportTimelineMissingSegmentQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.SegmentDescriptor;
import org.apache.hive.druid.org.apache.druid.query.SinkQueryRunners;
import org.apache.hive.druid.org.apache.druid.query.TableDataSource;
import org.apache.hive.druid.org.apache.druid.query.spec.SpecificSegmentQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.spec.SpecificSegmentSpec;
import org.apache.hive.druid.org.apache.druid.segment.Segment;
import org.apache.hive.druid.org.apache.druid.segment.realtime.FireHydrant;
import org.apache.hive.druid.org.apache.druid.segment.realtime.plumber.Sink;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentId;
import org.apache.hive.druid.org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionHolder;
import org.joda.time.Interval;

public class SinkQuerySegmentWalker
implements QuerySegmentWalker {
    private static final EmittingLogger log = new EmittingLogger(SinkQuerySegmentWalker.class);
    private static final String CONTEXT_SKIP_INCREMENTAL_SEGMENT = "skipIncrementalSegment";
    private final String dataSource;
    private final VersionedIntervalTimeline<String, Sink> sinkTimeline;
    private final ObjectMapper objectMapper;
    private final ServiceEmitter emitter;
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final ExecutorService queryExecutorService;
    private final Cache cache;
    private final CacheConfig cacheConfig;
    private final CachePopulatorStats cachePopulatorStats;

    public SinkQuerySegmentWalker(String dataSource, VersionedIntervalTimeline<String, Sink> sinkTimeline, ObjectMapper objectMapper, ServiceEmitter emitter, QueryRunnerFactoryConglomerate conglomerate, ExecutorService queryExecutorService, Cache cache, CacheConfig cacheConfig, CachePopulatorStats cachePopulatorStats) {
        this.dataSource = Preconditions.checkNotNull(dataSource, "dataSource");
        this.sinkTimeline = Preconditions.checkNotNull(sinkTimeline, "sinkTimeline");
        this.objectMapper = Preconditions.checkNotNull(objectMapper, "objectMapper");
        this.emitter = Preconditions.checkNotNull(emitter, "emitter");
        this.conglomerate = Preconditions.checkNotNull(conglomerate, "conglomerate");
        this.queryExecutorService = Preconditions.checkNotNull(queryExecutorService, "queryExecutorService");
        this.cache = Preconditions.checkNotNull(cache, "cache");
        this.cacheConfig = Preconditions.checkNotNull(cacheConfig, "cacheConfig");
        this.cachePopulatorStats = Preconditions.checkNotNull(cachePopulatorStats, "cachePopulatorStats");
        if (!cache.isLocal()) {
            log.warn("Configured cache[%s] is not local, caching will not be enabled.", cache.getClass().getName());
        }
    }

    @Override
    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        FunctionalIterable<SegmentDescriptor> specs = FunctionalIterable.create(intervals).transformCat(new Function<Interval, Iterable<TimelineObjectHolder<String, Sink>>>(){

            @Override
            public Iterable<TimelineObjectHolder<String, Sink>> apply(Interval interval) {
                return SinkQuerySegmentWalker.this.sinkTimeline.lookup(interval);
            }
        }).transformCat(new Function<TimelineObjectHolder<String, Sink>, Iterable<SegmentDescriptor>>(){

            @Override
            public Iterable<SegmentDescriptor> apply(final TimelineObjectHolder<String, Sink> holder) {
                return FunctionalIterable.create(holder.getObject()).transform(new Function<PartitionChunk<Sink>, SegmentDescriptor>(){

                    @Override
                    public SegmentDescriptor apply(PartitionChunk<Sink> chunk) {
                        return new SegmentDescriptor(holder.getInterval(), (String)holder.getVersion(), chunk.getChunkNumber());
                    }
                });
            }
        });
        return this.getQueryRunnerForSegments(query, specs);
    }

    @Override
    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        if (!(query.getDataSource() instanceof TableDataSource) || !this.dataSource.equals(((TableDataSource)query.getDataSource()).getName())) {
            log.makeAlert("Received query for unknown dataSource", new Object[0]).addData("dataSource", query.getDataSource()).emit();
            return new NoopQueryRunner();
        }
        QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        if (factory == null) {
            throw new ISE("Unknown query type[%s].", query.getClass());
        }
        QueryToolChest toolChest = factory.getToolchest();
        boolean skipIncrementalSegment = query.getContextValue(CONTEXT_SKIP_INCREMENTAL_SEGMENT, false);
        AtomicLong cpuTimeAccumulator = new AtomicLong(0L);
        Iterable perSegmentRunners = Iterables.transform(specs, descriptor -> {
            PartitionHolder<Sink> holder = this.sinkTimeline.findEntry(descriptor.getInterval(), descriptor.getVersion());
            if (holder == null) {
                return new ReportTimelineMissingSegmentQueryRunner((SegmentDescriptor)descriptor);
            }
            PartitionChunk<Sink> chunk = holder.getChunk(descriptor.getPartitionNumber());
            if (chunk == null) {
                return new ReportTimelineMissingSegmentQueryRunner((SegmentDescriptor)descriptor);
            }
            Sink theSink = chunk.getObject();
            SegmentId sinkSegmentId = theSink.getSegment().getId();
            SinkQueryRunners perHydrantRunners = new SinkQueryRunners(Iterables.transform(theSink, hydrant -> {
                boolean hydrantDefinitelySwapped = hydrant.hasSwapped();
                if (skipIncrementalSegment && !hydrantDefinitelySwapped) {
                    return new Pair(Intervals.ETERNITY, new NoopQueryRunner());
                }
                Pair<Segment, Closeable> segmentAndCloseable = hydrant.getAndIncrementSegment();
                try {
                    QueryRunner runner = factory.createRunner((Segment)segmentAndCloseable.lhs);
                    if (hydrantDefinitelySwapped && this.cache.isLocal()) {
                        runner = new CachingQueryRunner(SinkQuerySegmentWalker.makeHydrantCacheIdentifier(hydrant), (SegmentDescriptor)descriptor, this.objectMapper, this.cache, toolChest, runner, new ForegroundCachePopulator(this.objectMapper, this.cachePopulatorStats, this.cacheConfig.getMaxEntrySize()), this.cacheConfig);
                    }
                    runner = QueryRunnerHelper.makeClosingQueryRunner(runner, (Closeable)segmentAndCloseable.rhs);
                    return new Pair(((Segment)segmentAndCloseable.lhs).getDataInterval(), runner);
                }
                catch (RuntimeException e) {
                    CloseQuietly.close((Closeable)segmentAndCloseable.rhs);
                    throw e;
                }
            }));
            return new SpecificSegmentQueryRunner(this.withPerSinkMetrics(new BySegmentQueryRunner(sinkSegmentId, descriptor.getInterval().getStart(), factory.mergeRunners(Execs.directExecutor(), perHydrantRunners)), toolChest, sinkSegmentId, cpuTimeAccumulator), new SpecificSegmentSpec((SegmentDescriptor)descriptor));
        });
        QueryRunner mergedRunner = toolChest.mergeResults(factory.mergeRunners(this.queryExecutorService, perSegmentRunners));
        return CPUTimeMetricQueryRunner.safeBuild(new FinalizeResultsQueryRunner(mergedRunner, toolChest), toolChest, this.emitter, cpuTimeAccumulator, true);
    }

    private <T> QueryRunner<T> withPerSinkMetrics(QueryRunner<T> sinkRunner, QueryToolChest<T, ? extends Query<T>> queryToolChest, SegmentId sinkSegmentId, AtomicLong cpuTimeAccumulator) {
        String sinkSegmentIdString = sinkSegmentId.toString();
        return CPUTimeMetricQueryRunner.safeBuild(new MetricsEmittingQueryRunner<T>(this.emitter, queryToolChest, new MetricsEmittingQueryRunner<T>(this.emitter, queryToolChest, sinkRunner, QueryMetrics::reportSegmentTime, queryMetrics -> queryMetrics.segment(sinkSegmentIdString)), QueryMetrics::reportSegmentAndCacheTime, queryMetrics -> queryMetrics.segment(sinkSegmentIdString)).withWaitMeasuredFromNow(), queryToolChest, this.emitter, cpuTimeAccumulator, false);
    }

    public VersionedIntervalTimeline<String, Sink> getSinkTimeline() {
        return this.sinkTimeline;
    }

    public static String makeHydrantCacheIdentifier(FireHydrant input) {
        return input.getSegmentId() + "_" + input.getCount();
    }
}

