/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.realtime.firehose;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.org.apache.druid.data.input.FiniteFirehoseFactory;
import org.apache.hive.druid.org.apache.druid.data.input.InputSplit;
import org.apache.hive.druid.org.apache.druid.data.input.impl.HttpEntity;
import org.apache.hive.druid.org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.prefetch.PrefetchableTextFilesFirehoseFactory;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.metadata.PasswordProvider;
import org.apache.hive.druid.org.apache.druid.utils.CompressionUtils;

public class HttpFirehoseFactory
extends PrefetchableTextFilesFirehoseFactory<URI> {
    private static final Logger log = new Logger(HttpFirehoseFactory.class);
    private final List<URI> uris;
    @Nullable
    private final String httpAuthenticationUsername;
    @Nullable
    private final PasswordProvider httpAuthenticationPasswordProvider;

    @JsonCreator
    public HttpFirehoseFactory(@JsonProperty(value="uris") List<URI> uris, @JsonProperty(value="maxCacheCapacityBytes") Long maxCacheCapacityBytes, @JsonProperty(value="maxFetchCapacityBytes") Long maxFetchCapacityBytes, @JsonProperty(value="prefetchTriggerBytes") Long prefetchTriggerBytes, @JsonProperty(value="fetchTimeout") Long fetchTimeout, @JsonProperty(value="maxFetchRetry") Integer maxFetchRetry, @JsonProperty(value="httpAuthenticationUsername") @Nullable String httpAuthenticationUsername, @JsonProperty(value="httpAuthenticationPassword") @Nullable PasswordProvider httpAuthenticationPasswordProvider) {
        super(maxCacheCapacityBytes, maxFetchCapacityBytes, prefetchTriggerBytes, fetchTimeout, maxFetchRetry);
        Preconditions.checkArgument(uris.size() > 0, "Empty URIs");
        this.uris = uris;
        this.httpAuthenticationUsername = httpAuthenticationUsername;
        this.httpAuthenticationPasswordProvider = httpAuthenticationPasswordProvider;
    }

    @Nullable
    @JsonProperty
    public String getHttpAuthenticationUsername() {
        return this.httpAuthenticationUsername;
    }

    @Nullable
    @JsonProperty(value="httpAuthenticationPassword")
    public PasswordProvider getHttpAuthenticationPasswordProvider() {
        return this.httpAuthenticationPasswordProvider;
    }

    @JsonProperty
    public List<URI> getUris() {
        return this.uris;
    }

    @Override
    protected Collection<URI> initObjects() {
        return this.uris;
    }

    @Override
    protected InputStream openObjectStream(URI object) throws IOException {
        return this.openObjectStream(object, 0L);
    }

    @Override
    protected InputStream openObjectStream(URI object, long start) throws IOException {
        return HttpEntity.openInputStream(object, this.httpAuthenticationUsername, this.httpAuthenticationPasswordProvider, start);
    }

    @Override
    protected InputStream wrapObjectStream(URI object, InputStream stream) throws IOException {
        return CompressionUtils.decompress(stream, object.getPath());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpFirehoseFactory that = (HttpFirehoseFactory)o;
        return Objects.equals(this.uris, that.uris) && this.getMaxCacheCapacityBytes() == that.getMaxCacheCapacityBytes() && this.getMaxFetchCapacityBytes() == that.getMaxFetchCapacityBytes() && this.getPrefetchTriggerBytes() == that.getPrefetchTriggerBytes() && this.getFetchTimeout() == that.getFetchTimeout() && this.getMaxFetchRetry() == that.getMaxFetchRetry() && Objects.equals(this.httpAuthenticationUsername, that.getHttpAuthenticationUsername()) && Objects.equals(this.httpAuthenticationPasswordProvider, that.getHttpAuthenticationPasswordProvider());
    }

    public int hashCode() {
        return Objects.hash(this.uris, this.getMaxCacheCapacityBytes(), this.getMaxFetchCapacityBytes(), this.getPrefetchTriggerBytes(), this.getFetchTimeout(), this.getMaxFetchRetry(), this.httpAuthenticationUsername, this.httpAuthenticationPasswordProvider);
    }

    @Override
    protected Predicate<Throwable> getRetryCondition() {
        return e -> e instanceof IOException;
    }

    @Override
    public FiniteFirehoseFactory<StringInputRowParser, URI> withSplit(InputSplit<URI> split) {
        return new HttpFirehoseFactory(Collections.singletonList(split.get()), this.getMaxCacheCapacityBytes(), this.getMaxFetchCapacityBytes(), this.getPrefetchTriggerBytes(), this.getFetchTimeout(), this.getMaxFetchRetry(), this.getHttpAuthenticationUsername(), this.httpAuthenticationPasswordProvider);
    }
}

