/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.realtime.firehose;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.org.apache.druid.data.input.Firehose;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.prefetch.JsonIterator;
import org.apache.hive.druid.org.apache.druid.segment.transform.TransformSpec;
import org.apache.hive.druid.org.apache.druid.segment.transform.Transformer;

public class SqlFirehose
implements Firehose {
    private final Iterator<JsonIterator<Map<String, Object>>> resultIterator;
    private final MapInputRowParser parser;
    private final Closeable closer;
    @Nullable
    private JsonIterator<Map<String, Object>> lineIterator = null;
    private final Transformer transformer;

    public SqlFirehose(Iterator<JsonIterator<Map<String, Object>>> lineIterators, InputRowParser<?> parser, Closeable closer) {
        this.resultIterator = lineIterators;
        this.parser = new MapInputRowParser(parser.getParseSpec());
        this.transformer = TransformSpec.fromInputRowParser(parser).toTransformer();
        this.closer = closer;
    }

    @Override
    public boolean hasMore() {
        while ((this.lineIterator == null || !this.lineIterator.hasNext()) && this.resultIterator.hasNext()) {
            this.lineIterator = this.getNextLineIterator();
        }
        return this.lineIterator != null && this.lineIterator.hasNext();
    }

    @Override
    @Nullable
    public InputRow nextRow() {
        assert (this.lineIterator != null);
        Map<String, Object> mapToParse = this.lineIterator.next();
        return this.transformer.transform(Iterators.getOnlyElement(this.parser.parseBatch(mapToParse).iterator()));
    }

    private JsonIterator<Map<String, Object>> getNextLineIterator() {
        if (this.lineIterator != null) {
            this.lineIterator = null;
        }
        return this.resultIterator.next();
    }

    @Override
    public void close() throws IOException {
        if (this.lineIterator != null) {
            this.lineIterator.close();
        }
        this.closer.close();
    }
}

