/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.serde;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.org.apache.druid.segment.column.ValueType;
import org.apache.hive.druid.org.apache.druid.segment.data.BitmapSerde;
import org.apache.hive.druid.org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.hive.druid.org.apache.druid.segment.data.CompressedColumnarLongsSupplier;
import org.apache.hive.druid.org.apache.druid.segment.serde.ColumnPartSerde;
import org.apache.hive.druid.org.apache.druid.segment.serde.LongNumericColumnSupplier;
import org.apache.hive.druid.org.apache.druid.segment.serde.Serializer;

public class LongNumericColumnPartSerdeV2
implements ColumnPartSerde {
    @Nullable
    private final Serializer serializer;
    @Nullable
    private final ByteOrder byteOrder;
    @Nullable
    private final BitmapSerdeFactory bitmapSerdeFactory;

    @JsonCreator
    public static LongNumericColumnPartSerdeV2 createDeserializer(@JsonProperty(value="byteOrder") ByteOrder byteOrder, @JsonProperty(value="bitmapSerdeFactory") @Nullable BitmapSerdeFactory bitmapSerdeFactory) {
        return new LongNumericColumnPartSerdeV2(byteOrder, bitmapSerdeFactory != null ? bitmapSerdeFactory : new BitmapSerde.LegacyBitmapSerdeFactory(), null);
    }

    private LongNumericColumnPartSerdeV2(@Nullable ByteOrder byteOrder, @Nullable BitmapSerdeFactory bitmapSerdeFactory, @Nullable Serializer serializer) {
        this.byteOrder = byteOrder;
        this.bitmapSerdeFactory = bitmapSerdeFactory;
        this.serializer = serializer;
    }

    @JsonProperty
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @JsonProperty
    public BitmapSerdeFactory getBitmapSerdeFactory() {
        return this.bitmapSerdeFactory;
    }

    public static SerializerBuilder serializerBuilder() {
        return new SerializerBuilder();
    }

    @Override
    @Nullable
    public Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public ColumnPartSerde.Deserializer getDeserializer() {
        return (buffer, builder, columnConfig) -> {
            int offset = buffer.getInt();
            int initialPos = buffer.position();
            CompressedColumnarLongsSupplier column = CompressedColumnarLongsSupplier.fromByteBuffer(buffer, this.byteOrder);
            buffer.position(initialPos + offset);
            ImmutableBitmap bitmap = buffer.hasRemaining() ? this.bitmapSerdeFactory.getObjectStrategy().fromByteBufferWithSize(buffer) : this.bitmapSerdeFactory.getBitmapFactory().makeEmptyImmutableBitmap();
            builder.setType(ValueType.LONG).setHasMultipleValues(false).setNumericColumnSupplier(new LongNumericColumnSupplier(column, bitmap));
        };
    }

    public static class SerializerBuilder {
        @Nullable
        private ByteOrder byteOrder = null;
        @Nullable
        private Serializer delegate = null;
        @Nullable
        private BitmapSerdeFactory bitmapSerdeFactory = null;

        public SerializerBuilder withByteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public SerializerBuilder withDelegate(Serializer delegate) {
            this.delegate = delegate;
            return this;
        }

        public SerializerBuilder withBitmapSerdeFactory(BitmapSerdeFactory bitmapSerdeFactory) {
            this.bitmapSerdeFactory = bitmapSerdeFactory;
            return this;
        }

        public LongNumericColumnPartSerdeV2 build() {
            Serializer serializer = new Serializer(){

                @Override
                public long getSerializedSize() throws IOException {
                    return delegate.getSerializedSize();
                }

                @Override
                public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
                    delegate.writeTo(channel, smoosher);
                }
            };
            return new LongNumericColumnPartSerdeV2(this.byteOrder, this.bitmapSerdeFactory, serializer);
        }
    }
}

