/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.virtual;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.java.util.common.UOE;
import org.apache.hive.druid.org.apache.druid.math.expr.Expr;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprEval;
import org.apache.hive.druid.org.apache.druid.math.expr.Parser;
import org.apache.hive.druid.org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.expression.ExprUtils;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.BaseSingleValueDimensionSelector;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.ConstantExprEvalSelector;
import org.apache.hive.druid.org.apache.druid.segment.DimensionSelector;
import org.apache.hive.druid.org.apache.druid.segment.NilColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.org.apache.druid.segment.column.ValueType;
import org.apache.hive.druid.org.apache.druid.segment.data.IndexedInts;
import org.apache.hive.druid.org.apache.druid.segment.virtual.ExpressionColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.virtual.MultiValueExpressionDimensionSelector;
import org.apache.hive.druid.org.apache.druid.segment.virtual.RowBasedExpressionColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.virtual.SingleLongInputCachingExpressionColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.virtual.SingleStringInputCachingExpressionColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.virtual.SingleStringInputDimensionSelector;

public class ExpressionSelectors {
    private ExpressionSelectors() {
    }

    public static ColumnValueSelector makeColumnValueSelector(ColumnSelectorFactory columnSelectorFactory, Expr expression) {
        final ColumnValueSelector<ExprEval> baseSelector = ExpressionSelectors.makeExprEvalSelector(columnSelectorFactory, expression);
        return new ColumnValueSelector(){

            @Override
            public double getDouble() {
                return baseSelector.getDouble();
            }

            @Override
            public float getFloat() {
                return baseSelector.getFloat();
            }

            @Override
            public long getLong() {
                return baseSelector.getLong();
            }

            @Override
            public boolean isNull() {
                return baseSelector.isNull();
            }

            @Override
            @Nullable
            public Object getObject() {
                ExprEval eval = (ExprEval)baseSelector.getObject();
                return ExpressionSelectors.coerceEvalToSelectorObject(eval);
            }

            @Override
            public Class classOfObject() {
                return Object.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("baseSelector", baseSelector);
            }
        };
    }

    public static ColumnValueSelector<ExprEval> makeExprEvalSelector(ColumnSelectorFactory columnSelectorFactory, Expr expression) {
        Expr.BindingDetails exprDetails = expression.analyzeInputs();
        Parser.validateExpr(expression, exprDetails);
        List<String> columns = exprDetails.getRequiredBindingsList();
        if (columns.size() == 1) {
            String column = Iterables.getOnlyElement(columns);
            ColumnCapabilities capabilities = columnSelectorFactory.getColumnCapabilities(column);
            if (capabilities != null && capabilities.getType() == ValueType.LONG) {
                return new SingleLongInputCachingExpressionColumnValueSelector(columnSelectorFactory.makeColumnValueSelector(column), expression, !"__time".equals(column));
            }
            if (capabilities != null && capabilities.getType() == ValueType.STRING && capabilities.isDictionaryEncoded() && capabilities.isComplete() && !capabilities.hasMultipleValues() && exprDetails.getArrayBindings().isEmpty()) {
                return new SingleStringInputCachingExpressionColumnValueSelector(columnSelectorFactory.makeDimensionSelector(new DefaultDimensionSpec(column, column, ValueType.STRING)), expression);
            }
        }
        Pair<Set<String>, Set<String>> arrayUsage = ExpressionSelectors.examineColumnSelectorFactoryArrays(columnSelectorFactory, exprDetails, columns);
        Set actualArrays = (Set)arrayUsage.lhs;
        Set unknownIfArrays = (Set)arrayUsage.rhs;
        List<String> needsApplied = columns.stream().filter(c -> actualArrays.contains(c) && !exprDetails.getArrayBindings().contains(c)).collect(Collectors.toList());
        Expr finalExpr = needsApplied.size() > 0 ? Parser.applyUnappliedBindings(expression, exprDetails, needsApplied) : expression;
        Expr.ObjectBinding bindings = ExpressionSelectors.createBindings(exprDetails, columnSelectorFactory);
        if (bindings.equals(ExprUtils.nilBindings())) {
            return new ConstantExprEvalSelector(expression.eval(bindings));
        }
        if (unknownIfArrays.size() > 0) {
            return new RowBasedExpressionColumnValueSelector(finalExpr, exprDetails, bindings, unknownIfArrays);
        }
        return new ExpressionColumnValueSelector(finalExpr, bindings);
    }

    public static DimensionSelector makeDimensionSelector(ColumnSelectorFactory columnSelectorFactory, Expr expression, final ExtractionFn extractionFn) {
        boolean multiVal;
        String column;
        ColumnCapabilities capabilities;
        Expr.BindingDetails exprDetails = expression.analyzeInputs();
        Parser.validateExpr(expression, exprDetails);
        List<String> columns = exprDetails.getRequiredBindingsList();
        if (!(columns.size() != 1 || (capabilities = columnSelectorFactory.getColumnCapabilities(column = Iterables.getOnlyElement(columns))) == null || capabilities.getType() != ValueType.STRING || !capabilities.isDictionaryEncoded() || !capabilities.isComplete() || exprDetails.hasInputArrays() || exprDetails.isOutputArray() || capabilities.hasMultipleValues() && exprDetails.getFreeVariables().size() != 1)) {
            return new SingleStringInputDimensionSelector(columnSelectorFactory.makeDimensionSelector(new DefaultDimensionSpec(column, column, ValueType.STRING)), expression);
        }
        Pair<Set<String>, Set<String>> arrayUsage = ExpressionSelectors.examineColumnSelectorFactoryArrays(columnSelectorFactory, exprDetails, columns);
        Set actualArrays = (Set)arrayUsage.lhs;
        Set unknownIfArrays = (Set)arrayUsage.rhs;
        final ColumnValueSelector<ExprEval> baseSelector = ExpressionSelectors.makeExprEvalSelector(columnSelectorFactory, expression);
        boolean bl = multiVal = actualArrays.size() > 0 || exprDetails.getArrayBindings().size() > 0 || unknownIfArrays.size() > 0;
        if (baseSelector instanceof ConstantExprEvalSelector) {
            return DimensionSelector.constant(((ExprEval)baseSelector.getObject()).asString(), extractionFn);
        }
        if (baseSelector instanceof NilColumnValueSelector) {
            return DimensionSelector.constant(null);
        }
        if (extractionFn == null) {
            if (multiVal) {
                return new MultiValueExpressionDimensionSelector(baseSelector);
            }
            class DefaultExpressionDimensionSelector
            extends BaseSingleValueDimensionSelector {
                final /* synthetic */ ColumnValueSelector val$baseSelector;

                DefaultExpressionDimensionSelector(ColumnValueSelector columnValueSelector) {
                    this.val$baseSelector = columnValueSelector;
                }

                @Override
                protected String getValue() {
                    return NullHandling.emptyToNullIfNeeded(((ExprEval)this.val$baseSelector.getObject()).asString());
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("baseSelector", this.val$baseSelector);
                }
            }
            return new DefaultExpressionDimensionSelector(baseSelector);
        }
        if (multiVal) {
            class ExtractionMultiValueDimensionSelector
            extends MultiValueExpressionDimensionSelector {
                ExtractionMultiValueDimensionSelector() {
                    super(columnValueSelector);
                }

                @Override
                String getValue(ExprEval evaluated) {
                    assert (!evaluated.isArray());
                    return extractionFn.apply(NullHandling.emptyToNullIfNeeded(evaluated.asString()));
                }

                @Override
                List<String> getArray(ExprEval evaluated) {
                    assert (evaluated.isArray());
                    return Arrays.stream(evaluated.asStringArray()).map(x -> extractionFn.apply(NullHandling.emptyToNullIfNeeded(x))).collect(Collectors.toList());
                }

                @Override
                String getArrayValue(ExprEval evaluated, int i) {
                    assert (evaluated.isArray());
                    String[] stringArray = evaluated.asStringArray();
                    assert (i < stringArray.length);
                    return extractionFn.apply(NullHandling.emptyToNullIfNeeded(stringArray[i]));
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("baseSelector", baseSelector);
                    inspector.visit("extractionFn", extractionFn);
                }
            }
            return new ExtractionMultiValueDimensionSelector();
        }
        class ExtractionExpressionDimensionSelector
        extends BaseSingleValueDimensionSelector {
            ExtractionExpressionDimensionSelector() {
            }

            @Override
            protected String getValue() {
                return extractionFn.apply(NullHandling.emptyToNullIfNeeded(((ExprEval)baseSelector.getObject()).asString()));
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("baseSelector", baseSelector);
                inspector.visit("extractionFn", extractionFn);
            }
        }
        return new ExtractionExpressionDimensionSelector();
    }

    private static Expr.ObjectBinding createBindings(Expr.BindingDetails bindingDetails, ColumnSelectorFactory columnSelectorFactory) {
        HashMap<String, Supplier<Object>> suppliers = new HashMap<String, Supplier<Object>>();
        List<String> columns = bindingDetails.getRequiredBindingsList();
        for (String columnName : columns) {
            Supplier<Object> supplier;
            ColumnValueSelector selector;
            boolean multiVal;
            ColumnCapabilities columnCapabilities = columnSelectorFactory.getColumnCapabilities(columnName);
            ValueType nativeType = columnCapabilities != null ? columnCapabilities.getType() : null;
            boolean bl = multiVal = columnCapabilities != null && columnCapabilities.hasMultipleValues();
            if (nativeType == ValueType.FLOAT) {
                selector = columnSelectorFactory.makeColumnValueSelector(columnName);
                supplier = ExpressionSelectors.makeNullableNumericSupplier(selector, selector::getFloat);
            } else if (nativeType == ValueType.LONG) {
                selector = columnSelectorFactory.makeColumnValueSelector(columnName);
                supplier = ExpressionSelectors.makeNullableNumericSupplier(selector, selector::getLong);
            } else if (nativeType == ValueType.DOUBLE) {
                selector = columnSelectorFactory.makeColumnValueSelector(columnName);
                supplier = ExpressionSelectors.makeNullableNumericSupplier(selector, selector::getDouble);
            } else {
                supplier = nativeType == ValueType.STRING ? ExpressionSelectors.supplierFromDimensionSelector(columnSelectorFactory.makeDimensionSelector(new DefaultDimensionSpec(columnName, columnName)), multiVal) : (nativeType == null ? ExpressionSelectors.supplierFromObjectSelector(columnSelectorFactory.makeColumnValueSelector(columnName)) : null);
            }
            if (supplier == null) continue;
            suppliers.put(columnName, supplier);
        }
        if (suppliers.isEmpty()) {
            return ExprUtils.nilBindings();
        }
        if (suppliers.size() == 1 && columns.size() == 1) {
            String column = (String)Iterables.getOnlyElement(suppliers.keySet());
            Supplier supplier = (Supplier)Iterables.getOnlyElement(suppliers.values());
            return identifierName -> {
                assert (column.equals(identifierName));
                return supplier.get();
            };
        }
        return Parser.withSuppliers(suppliers);
    }

    private static <T> Supplier<T> makeNullableNumericSupplier(ColumnValueSelector selector, Supplier<T> supplier) {
        if (NullHandling.replaceWithDefault()) {
            return supplier;
        }
        return () -> {
            if (selector.isNull()) {
                return null;
            }
            return supplier.get();
        };
    }

    @VisibleForTesting
    static Supplier<Object> supplierFromDimensionSelector(DimensionSelector selector, boolean coerceArray) {
        Preconditions.checkNotNull(selector, "selector");
        return () -> {
            IndexedInts row = selector.getRow();
            if (row.size() == 1 && !coerceArray) {
                return selector.lookupName(row.get(0));
            }
            if (row.size() == 0) {
                return new String[]{null};
            }
            String[] strings = new String[row.size()];
            for (int i = 0; i < row.size(); ++i) {
                strings[i] = selector.lookupName(row.get(i));
            }
            return strings;
        };
    }

    @Nullable
    static Supplier<Object> supplierFromObjectSelector(BaseObjectColumnValueSelector<?> selector) {
        Class<Object> clazz;
        block7: {
            block6: {
                if (selector instanceof NilColumnValueSelector) {
                    return null;
                }
                clazz = selector.classOfObject();
                if (Number.class.isAssignableFrom(clazz)) break block6;
                if (!String.class.isAssignableFrom(clazz)) break block7;
            }
            return selector::getObject;
        }
        if (clazz.isAssignableFrom(Number.class) || clazz.isAssignableFrom(String.class)) {
            return () -> {
                Object val = selector.getObject();
                if (val instanceof Number || val instanceof String) {
                    return val;
                }
                if (val instanceof List) {
                    return ExpressionSelectors.coerceListToArray((List)val);
                }
                return null;
            };
        }
        if (clazz.isAssignableFrom(List.class)) {
            return () -> {
                Object val = selector.getObject();
                if (val != null) {
                    return ExpressionSelectors.coerceListToArray((List)val);
                }
                return null;
            };
        }
        return null;
    }

    public static Object coerceListToArray(@Nullable List<?> val) {
        if (val != null && val.size() > 0) {
            Class coercedType = null;
            for (Object elem : val) {
                if (elem == null) continue;
                coercedType = ExpressionSelectors.convertType(coercedType, elem.getClass());
            }
            if (coercedType == Long.class || coercedType == Integer.class) {
                return val.stream().map(x -> x != null ? Long.valueOf(((Number)x).longValue()) : null).toArray(Long[]::new);
            }
            if (coercedType == Float.class || coercedType == Double.class) {
                return val.stream().map(x -> x != null ? Double.valueOf(((Number)x).doubleValue()) : null).toArray(Double[]::new);
            }
            return val.stream().map(x -> x != null ? x.toString() : null).toArray(String[]::new);
        }
        return new String[]{null};
    }

    private static Class convertType(@Nullable Class existing, Class next) {
        if (Number.class.isAssignableFrom(next) || next == String.class) {
            if (existing == null) {
                return next;
            }
            if (existing == String.class) {
                return existing;
            }
            if (next == String.class) {
                return next;
            }
            if (existing == Integer.class) {
                return next;
            }
            if (existing == Float.class) {
                if (next == Double.class) {
                    return next;
                }
                return existing;
            }
            if (existing == Long.class) {
                if (next == Integer.class) {
                    return existing;
                }
                return next;
            }
            return Double.class;
        }
        throw new UOE("Invalid array expression type: %s", next);
    }

    @Nullable
    public static Object coerceEvalToSelectorObject(ExprEval eval) {
        switch (eval.type()) {
            case STRING_ARRAY: {
                return Arrays.stream(eval.asStringArray()).collect(Collectors.toList());
            }
            case DOUBLE_ARRAY: {
                return Arrays.stream(eval.asDoubleArray()).collect(Collectors.toList());
            }
            case LONG_ARRAY: {
                return Arrays.stream(eval.asLongArray()).collect(Collectors.toList());
            }
        }
        return eval.value();
    }

    private static Pair<Set<String>, Set<String>> examineColumnSelectorFactoryArrays(ColumnSelectorFactory columnSelectorFactory, Expr.BindingDetails exprDetails, List<String> columns) {
        HashSet<String> actualArrays = new HashSet<String>();
        HashSet<String> unknownIfArrays = new HashSet<String>();
        for (String column : columns) {
            ColumnCapabilities capabilities = columnSelectorFactory.getColumnCapabilities(column);
            if (capabilities != null) {
                if (capabilities.hasMultipleValues()) {
                    actualArrays.add(column);
                    continue;
                }
                if (capabilities.isComplete() || !capabilities.getType().equals((Object)ValueType.STRING) || exprDetails.getArrayBindings().contains(column)) continue;
                unknownIfArrays.add(column);
                continue;
            }
            unknownIfArrays.add(column);
        }
        return new Pair<Set<String>, Set<String>>(actualArrays, unknownIfArrays);
    }
}

