/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordination;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.druid.client.CachingQueryRunner;
import org.apache.hive.druid.org.apache.druid.client.cache.Cache;
import org.apache.hive.druid.org.apache.druid.client.cache.CacheConfig;
import org.apache.hive.druid.org.apache.druid.client.cache.CachePopulator;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Processing;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Smile;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.FunctionalIterable;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.query.BySegmentQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.CPUTimeMetricQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.DataSource;
import org.apache.hive.druid.org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.MetricsEmittingQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.NoopQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.PerSegmentOptimizingQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.PerSegmentQueryOptimizationContext;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryDataSource;
import org.apache.hive.druid.org.apache.druid.query.QueryMetrics;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.hive.druid.org.apache.druid.query.QuerySegmentWalker;
import org.apache.hive.druid.org.apache.druid.query.QueryToolChest;
import org.apache.hive.druid.org.apache.druid.query.ReferenceCountingSegmentQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.ReportTimelineMissingSegmentQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.SegmentDescriptor;
import org.apache.hive.druid.org.apache.druid.query.TableDataSource;
import org.apache.hive.druid.org.apache.druid.query.spec.SpecificSegmentQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.spec.SpecificSegmentSpec;
import org.apache.hive.druid.org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.hive.druid.org.apache.druid.server.SegmentManager;
import org.apache.hive.druid.org.apache.druid.server.SetAndVerifyContextQueryRunner;
import org.apache.hive.druid.org.apache.druid.server.initialization.ServerConfig;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentId;
import org.apache.hive.druid.org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionHolder;
import org.joda.time.Interval;

public class ServerManager
implements QuerySegmentWalker {
    private static final EmittingLogger log = new EmittingLogger(ServerManager.class);
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final ServiceEmitter emitter;
    private final ExecutorService exec;
    private final CachePopulator cachePopulator;
    private final Cache cache;
    private final ObjectMapper objectMapper;
    private final CacheConfig cacheConfig;
    private final SegmentManager segmentManager;
    private final ServerConfig serverConfig;

    @Inject
    public ServerManager(QueryRunnerFactoryConglomerate conglomerate, ServiceEmitter emitter, @Processing ExecutorService exec, CachePopulator cachePopulator, @Smile ObjectMapper objectMapper, Cache cache, CacheConfig cacheConfig, SegmentManager segmentManager, ServerConfig serverConfig) {
        this.conglomerate = conglomerate;
        this.emitter = emitter;
        this.exec = exec;
        this.cachePopulator = cachePopulator;
        this.cache = cache;
        this.objectMapper = objectMapper;
        this.cacheConfig = cacheConfig;
        this.segmentManager = segmentManager;
        this.serverConfig = serverConfig;
    }

    private DataSource getInnerMostDataSource(DataSource dataSource) {
        if (dataSource instanceof QueryDataSource) {
            return this.getInnerMostDataSource(((QueryDataSource)dataSource).getQuery().getDataSource());
        }
        return dataSource;
    }

    @Override
    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        final QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        if (factory == null) {
            throw new ISE("Unknown query type[%s].", query.getClass());
        }
        final QueryToolChest toolChest = factory.getToolchest();
        final AtomicLong cpuTimeAccumulator = new AtomicLong(0L);
        DataSource dataSource = this.getInnerMostDataSource(query.getDataSource());
        if (!(dataSource instanceof TableDataSource)) {
            throw new UnsupportedOperationException("data source type '" + dataSource.getClass().getName() + "' unsupported");
        }
        String dataSourceName = this.getDataSourceName(dataSource);
        final VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline = this.segmentManager.getTimeline(dataSourceName);
        if (timeline == null) {
            return new NoopQueryRunner();
        }
        FunctionalIterable queryRunners = FunctionalIterable.create(intervals).transformCat(new Function<Interval, Iterable<TimelineObjectHolder<String, ReferenceCountingSegment>>>(){

            @Override
            public Iterable<TimelineObjectHolder<String, ReferenceCountingSegment>> apply(Interval input) {
                return timeline.lookup(input);
            }
        }).transformCat(new Function<TimelineObjectHolder<String, ReferenceCountingSegment>, Iterable<QueryRunner<T>>>(){

            @Override
            public Iterable<QueryRunner<T>> apply(final @Nullable TimelineObjectHolder<String, ReferenceCountingSegment> holder) {
                if (holder == null) {
                    return null;
                }
                return FunctionalIterable.create(holder.getObject()).transform(new Function<PartitionChunk<ReferenceCountingSegment>, QueryRunner<T>>(){

                    @Override
                    public QueryRunner<T> apply(PartitionChunk<ReferenceCountingSegment> input) {
                        return ServerManager.this.buildAndDecorateQueryRunner(factory, toolChest, input.getObject(), new SegmentDescriptor(holder.getInterval(), (String)holder.getVersion(), input.getChunkNumber()), cpuTimeAccumulator);
                    }
                });
            }
        });
        return CPUTimeMetricQueryRunner.safeBuild(new FinalizeResultsQueryRunner(toolChest.mergeResults(factory.mergeRunners(this.exec, queryRunners)), toolChest), toolChest, this.emitter, cpuTimeAccumulator, true);
    }

    private String getDataSourceName(DataSource dataSource) {
        return Iterables.getOnlyElement(dataSource.getNames());
    }

    @Override
    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        final QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        if (factory == null) {
            log.makeAlert("Unknown query type, [%s]", query.getClass()).addData("dataSource", query.getDataSource()).emit();
            return new NoopQueryRunner();
        }
        final QueryToolChest toolChest = factory.getToolchest();
        String dataSourceName = this.getDataSourceName(query.getDataSource());
        final VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline = this.segmentManager.getTimeline(dataSourceName);
        if (timeline == null) {
            return new NoopQueryRunner();
        }
        final AtomicLong cpuTimeAccumulator = new AtomicLong(0L);
        FunctionalIterable queryRunners = FunctionalIterable.create(specs).transformCat(new Function<SegmentDescriptor, Iterable<QueryRunner<T>>>(){

            @Override
            public Iterable<QueryRunner<T>> apply(SegmentDescriptor input) {
                PartitionHolder entry = timeline.findEntry(input.getInterval(), input.getVersion());
                if (entry == null) {
                    return Collections.singletonList(new ReportTimelineMissingSegmentQueryRunner(input));
                }
                PartitionChunk chunk = entry.getChunk(input.getPartitionNumber());
                if (chunk == null) {
                    return Collections.singletonList(new ReportTimelineMissingSegmentQueryRunner(input));
                }
                ReferenceCountingSegment adapter = (ReferenceCountingSegment)chunk.getObject();
                return Collections.singletonList(ServerManager.this.buildAndDecorateQueryRunner(factory, toolChest, adapter, input, cpuTimeAccumulator));
            }
        });
        return CPUTimeMetricQueryRunner.safeBuild(new FinalizeResultsQueryRunner(toolChest.mergeResults(factory.mergeRunners(this.exec, queryRunners)), toolChest), toolChest, this.emitter, cpuTimeAccumulator, true);
    }

    private <T> QueryRunner<T> buildAndDecorateQueryRunner(QueryRunnerFactory<T, Query<T>> factory, QueryToolChest<T, Query<T>> toolChest, ReferenceCountingSegment adapter, SegmentDescriptor segmentDescriptor, AtomicLong cpuTimeAccumulator) {
        SpecificSegmentSpec segmentSpec = new SpecificSegmentSpec(segmentDescriptor);
        SegmentId segmentId = adapter.getId();
        String segmentIdString = segmentId.toString();
        MetricsEmittingQueryRunner<T> metricsEmittingQueryRunnerInner = new MetricsEmittingQueryRunner<T>(this.emitter, toolChest, new ReferenceCountingSegmentQueryRunner<T>(factory, adapter, segmentDescriptor), QueryMetrics::reportSegmentTime, queryMetrics -> queryMetrics.segment(segmentIdString));
        CachingQueryRunner<T> cachingQueryRunner = new CachingQueryRunner<T>(segmentIdString, segmentDescriptor, this.objectMapper, this.cache, toolChest, metricsEmittingQueryRunnerInner, this.cachePopulator, this.cacheConfig);
        BySegmentQueryRunner<T> bySegmentQueryRunner = new BySegmentQueryRunner<T>(segmentId, adapter.getDataInterval().getStart(), cachingQueryRunner);
        MetricsEmittingQueryRunner<T> metricsEmittingQueryRunnerOuter = new MetricsEmittingQueryRunner<T>(this.emitter, toolChest, bySegmentQueryRunner, QueryMetrics::reportSegmentAndCacheTime, queryMetrics -> queryMetrics.segment(segmentIdString)).withWaitMeasuredFromNow();
        SpecificSegmentQueryRunner<T> specificSegmentQueryRunner = new SpecificSegmentQueryRunner<T>(metricsEmittingQueryRunnerOuter, segmentSpec);
        PerSegmentOptimizingQueryRunner<T> perSegmentOptimizingQueryRunner = new PerSegmentOptimizingQueryRunner<T>(specificSegmentQueryRunner, new PerSegmentQueryOptimizationContext(segmentDescriptor));
        return new SetAndVerifyContextQueryRunner<T>(this.serverConfig, CPUTimeMetricQueryRunner.safeBuild(perSegmentOptimizingQueryRunner, toolChest, this.emitter, cpuTimeAccumulator, false));
    }
}

