/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.coordinator.rules;

import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.org.apache.druid.server.coordinator.rules.DropRule;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;

public class PeriodDropRule
extends DropRule {
    private static final boolean DEFAULT_INCLUDE_FUTURE = true;
    private final Period period;
    private final boolean includeFuture;

    @JsonCreator
    public PeriodDropRule(@JsonProperty(value="period") Period period, @JsonProperty(value="includeFuture") Boolean includeFuture) {
        this.period = period;
        this.includeFuture = includeFuture == null ? true : includeFuture;
    }

    @Override
    @JsonProperty
    public String getType() {
        return "dropByPeriod";
    }

    @JsonProperty
    public Period getPeriod() {
        return this.period;
    }

    @JsonProperty
    public boolean isIncludeFuture() {
        return this.includeFuture;
    }

    @Override
    public boolean appliesTo(DataSegment segment, DateTime referenceTimestamp) {
        return this.appliesTo(segment.getInterval(), referenceTimestamp);
    }

    @Override
    public boolean appliesTo(Interval theInterval, DateTime referenceTimestamp) {
        Interval currInterval = new Interval((ReadablePeriod)this.period, (ReadableInstant)referenceTimestamp);
        if (this.includeFuture) {
            return currInterval.getStartMillis() <= theInterval.getStartMillis();
        }
        return currInterval.contains((ReadableInterval)theInterval);
    }
}

