/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.emitter;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.guice.LazySingleton;
import org.apache.hive.druid.org.apache.druid.guice.ManageLifecycle;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Self;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.server.DruidNode;
import org.apache.hive.druid.org.apache.druid.server.emitter.ComposingEmitterModule;
import org.apache.hive.druid.org.apache.druid.server.emitter.ExtraServiceDimensions;
import org.apache.hive.druid.org.apache.druid.server.emitter.HttpEmitterModule;
import org.apache.hive.druid.org.apache.druid.server.emitter.LogEmitterModule;
import org.apache.hive.druid.org.apache.druid.server.emitter.NoopEmitterModule;
import org.apache.hive.druid.org.apache.druid.server.emitter.ParametrizedUriEmitterModule;

public class EmitterModule
implements Module {
    private static final Logger log = new Logger(EmitterModule.class);
    private static final String EMITTER_PROPERTY = "druid.emitter";
    private final Properties props;

    @Inject
    public EmitterModule(Properties props) {
        this.props = props;
    }

    public void configure(Binder binder) {
        String emitterType = this.props.getProperty(EMITTER_PROPERTY, "");
        binder.install((Module)new NoopEmitterModule());
        binder.install((Module)new LogEmitterModule());
        binder.install((Module)new HttpEmitterModule());
        binder.install((Module)new ParametrizedUriEmitterModule());
        binder.install((Module)new ComposingEmitterModule());
        binder.bind(Emitter.class).toProvider((Provider)new EmitterProvider(emitterType)).in(LazySingleton.class);
        MapBinder extraServiceDimensions = MapBinder.newMapBinder((Binder)binder, String.class, String.class, ExtraServiceDimensions.class);
        String version = this.getClass().getPackage().getImplementationVersion();
        extraServiceDimensions.addBinding((Object)"version").toInstance((Object)StringUtils.nullToEmptyNonDruidDataString(version));
    }

    @Provides
    @ManageLifecycle
    public ServiceEmitter getServiceEmitter(@Self Supplier<DruidNode> configSupplier, Emitter emitter, @ExtraServiceDimensions Map<String, String> extraServiceDimensions) {
        DruidNode config = configSupplier.get();
        log.info("Using emitter [%s] for metrics and alerts, with dimensions [%s].", emitter, extraServiceDimensions);
        ServiceEmitter retVal = new ServiceEmitter(config.getServiceName(), config.getHostAndPortToUse(), emitter, ImmutableMap.copyOf(extraServiceDimensions));
        EmittingLogger.registerEmitter(retVal);
        return retVal;
    }

    private static class EmitterProvider
    implements Provider<Emitter> {
        private final String emitterType;
        private Emitter emitter = null;

        EmitterProvider(String emitterType) {
            this.emitterType = emitterType;
        }

        @Inject
        public void inject(Injector injector) {
            List emitterBindings = injector.findBindingsByType((TypeLiteral)new TypeLiteral<Emitter>(){});
            this.emitter = Strings.isNullOrEmpty(this.emitterType) ? this.findEmitter("noop", emitterBindings) : this.findEmitter(this.emitterType, emitterBindings);
            if (this.emitter == null) {
                ArrayList<String> knownTypes = new ArrayList<String>();
                for (Binding binding : emitterBindings) {
                    Annotation annotation = binding.getKey().getAnnotation();
                    if (annotation == null) continue;
                    knownTypes.add(((Named)annotation).value());
                }
                throw new ISE("Unknown emitter type[%s]=[%s], known types[%s]", EmitterModule.EMITTER_PROPERTY, this.emitterType, knownTypes);
            }
        }

        private Emitter findEmitter(String emitterType, List<Binding<Emitter>> emitterBindings) {
            for (Binding<Emitter> binding : emitterBindings) {
                if (!Names.named((String)emitterType).equals(binding.getKey().getAnnotation())) continue;
                return (Emitter)binding.getProvider().get();
            }
            return null;
        }

        public Emitter get() {
            if (this.emitter == null) {
                throw new ISE("Emitter was null, that's bad!", new Object[0]);
            }
            return this.emitter;
        }
    }
}

