/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server.http;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.util.concurrent.FutureCallback;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.org.apache.druid.client.HttpServerInventoryView;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Json;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Smile;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.server.coordination.BatchDataSegmentAnnouncer;
import org.apache.hive.druid.org.apache.druid.server.coordination.ChangeRequestHistory;
import org.apache.hive.druid.org.apache.druid.server.coordination.ChangeRequestsSnapshot;
import org.apache.hive.druid.org.apache.druid.server.coordination.DataSegmentChangeRequest;
import org.apache.hive.druid.org.apache.druid.server.coordination.SegmentLoadDropHandler;
import org.apache.hive.druid.org.apache.druid.server.coordinator.HttpLoadQueuePeon;
import org.apache.hive.druid.org.apache.druid.server.http.security.StateResourceFilter;

@Path(value="/druid-internal/v1/segments/")
@ResourceFilters(value={StateResourceFilter.class})
public class SegmentListerResource {
    protected static final EmittingLogger log = new EmittingLogger(SegmentListerResource.class);
    protected final ObjectMapper jsonMapper;
    protected final ObjectMapper smileMapper;
    private final BatchDataSegmentAnnouncer announcer;
    private final SegmentLoadDropHandler loadDropRequestHandler;

    @Inject
    public SegmentListerResource(@Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, @Nullable BatchDataSegmentAnnouncer announcer, @Nullable SegmentLoadDropHandler loadDropRequestHandler) {
        this.jsonMapper = jsonMapper;
        this.smileMapper = smileMapper;
        this.announcer = announcer;
        this.loadDropRequestHandler = loadDropRequestHandler;
    }

    @GET
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Consumes(value={"application/json", "application/x-jackson-smile"})
    public Void getSegments(@QueryParam(value="counter") long counter, @QueryParam(value="hash") long hash, @QueryParam(value="timeout") long timeout, @Context HttpServletRequest req) throws IOException {
        if (this.announcer == null) {
            this.sendErrorResponse(req, 404, "announcer is not available.");
            return null;
        }
        if (timeout <= 0L) {
            this.sendErrorResponse(req, 400, "timeout must be positive.");
            return null;
        }
        final ResponseContext context = this.createContext(req.getHeader("Accept"));
        final ListenableFuture<ChangeRequestsSnapshot<DataSegmentChangeRequest>> future = this.announcer.getSegmentChangesSince(new ChangeRequestHistory.Counter(counter, hash));
        final AsyncContext asyncContext = req.startAsync();
        asyncContext.addListener(new AsyncListener(){

            public void onComplete(AsyncEvent event) {
            }

            public void onTimeout(AsyncEvent event) {
                future.cancel(true);
                event.getAsyncContext().complete();
            }

            public void onError(AsyncEvent event) {
            }

            public void onStartAsync(AsyncEvent event) {
            }
        });
        Futures.addCallback(future, new FutureCallback<ChangeRequestsSnapshot<DataSegmentChangeRequest>>(){

            @Override
            public void onSuccess(ChangeRequestsSnapshot<DataSegmentChangeRequest> result) {
                try {
                    HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
                    response.setStatus(200);
                    context.inputMapper.writerWithType(HttpServerInventoryView.SEGMENT_LIST_RESP_TYPE_REF).writeValue((OutputStream)asyncContext.getResponse().getOutputStream(), result);
                    asyncContext.complete();
                }
                catch (Exception ex) {
                    log.debug(ex, "Request timed out or closed already.", new Object[0]);
                }
            }

            @Override
            public void onFailure(Throwable th) {
                try {
                    HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
                    if (th instanceof IllegalArgumentException) {
                        response.sendError(400, th.getMessage());
                    } else {
                        response.sendError(500, th.getMessage());
                    }
                    asyncContext.complete();
                }
                catch (Exception ex) {
                    log.debug(ex, "Request timed out or closed already.", new Object[0]);
                }
            }
        });
        asyncContext.setTimeout(timeout);
        return null;
    }

    @POST
    @Path(value="/changeRequests")
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Consumes(value={"application/json", "application/x-jackson-smile"})
    public void applyDataSegmentChangeRequests(@QueryParam(value="timeout") long timeout, List<DataSegmentChangeRequest> changeRequestList, @Context HttpServletRequest req) throws IOException {
        if (this.loadDropRequestHandler == null) {
            this.sendErrorResponse(req, 404, "load/drop handler is not available.");
            return;
        }
        if (timeout <= 0L) {
            this.sendErrorResponse(req, 400, "timeout must be positive.");
            return;
        }
        if (changeRequestList == null || changeRequestList.isEmpty()) {
            this.sendErrorResponse(req, 400, "No change requests provided.");
            return;
        }
        final ResponseContext context = this.createContext(req.getHeader("Accept"));
        final ListenableFuture<List<SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus>> future = this.loadDropRequestHandler.processBatch(changeRequestList);
        final AsyncContext asyncContext = req.startAsync();
        asyncContext.addListener(new AsyncListener(){

            public void onComplete(AsyncEvent event) {
            }

            public void onTimeout(AsyncEvent event) {
                future.cancel(true);
                event.getAsyncContext().complete();
            }

            public void onError(AsyncEvent event) {
            }

            public void onStartAsync(AsyncEvent event) {
            }
        });
        Futures.addCallback(future, new FutureCallback<List<SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus>>(){

            @Override
            public void onSuccess(List<SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus> result) {
                try {
                    HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
                    response.setStatus(200);
                    context.inputMapper.writerWithType(HttpLoadQueuePeon.RESPONSE_ENTITY_TYPE_REF).writeValue((OutputStream)asyncContext.getResponse().getOutputStream(), result);
                    asyncContext.complete();
                }
                catch (Exception ex) {
                    log.debug(ex, "Request timed out or closed already.", new Object[0]);
                }
            }

            @Override
            public void onFailure(Throwable th) {
                try {
                    HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
                    if (th instanceof IllegalArgumentException) {
                        response.sendError(400, th.getMessage());
                    } else {
                        response.sendError(500, th.getMessage());
                    }
                    asyncContext.complete();
                }
                catch (Exception ex) {
                    log.debug(ex, "Request timed out or closed already.", new Object[0]);
                }
            }
        });
        asyncContext.setTimeout(timeout);
    }

    private void sendErrorResponse(HttpServletRequest req, int code, String error) throws IOException {
        AsyncContext asyncContext = req.startAsync();
        HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
        response.sendError(code, error);
        asyncContext.complete();
    }

    private ResponseContext createContext(String requestType) {
        boolean isSmile = "application/x-jackson-smile".equals(requestType);
        return new ResponseContext(isSmile ? this.smileMapper : this.jsonMapper);
    }

    private static class ResponseContext {
        private final ObjectMapper inputMapper;

        ResponseContext(ObjectMapper inputMapper) {
            this.inputMapper = inputMapper;
        }
    }
}

