/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.storage.hdfs;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.multibindings.MapBinder;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hive.druid.com.fasterxml.jackson.databind.Module;
import org.apache.hive.druid.com.fasterxml.jackson.databind.jsontype.NamedType;
import org.apache.hive.druid.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.hive.druid.org.apache.druid.data.SearchableVersionedDataFinder;
import org.apache.hive.druid.org.apache.druid.firehose.hdfs.HdfsFirehoseFactory;
import org.apache.hive.druid.org.apache.druid.guice.Binders;
import org.apache.hive.druid.org.apache.druid.guice.Hdfs;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.org.apache.druid.guice.LazySingleton;
import org.apache.hive.druid.org.apache.druid.guice.LifecycleModule;
import org.apache.hive.druid.org.apache.druid.guice.ManageLifecycle;
import org.apache.hive.druid.org.apache.druid.initialization.DruidModule;
import org.apache.hive.druid.org.apache.druid.inputsource.hdfs.HdfsInputSource;
import org.apache.hive.druid.org.apache.druid.storage.hdfs.HdfsDataSegmentKiller;
import org.apache.hive.druid.org.apache.druid.storage.hdfs.HdfsDataSegmentPusher;
import org.apache.hive.druid.org.apache.druid.storage.hdfs.HdfsDataSegmentPusherConfig;
import org.apache.hive.druid.org.apache.druid.storage.hdfs.HdfsFileTimestampVersionFinder;
import org.apache.hive.druid.org.apache.druid.storage.hdfs.HdfsKerberosConfig;
import org.apache.hive.druid.org.apache.druid.storage.hdfs.HdfsLoadSpec;
import org.apache.hive.druid.org.apache.druid.storage.hdfs.HdfsStorageAuthentication;
import org.apache.hive.druid.org.apache.druid.storage.hdfs.tasklog.HdfsTaskLogs;
import org.apache.hive.druid.org.apache.druid.storage.hdfs.tasklog.HdfsTaskLogsConfig;

public class HdfsStorageDruidModule
implements DruidModule {
    static final String SCHEME = "hdfs";
    private Properties props = null;

    @Inject
    public void setProperties(Properties props) {
        this.props = props;
    }

    @Override
    public List<? extends Module> getJacksonModules() {
        return Collections.singletonList(new SimpleModule().registerSubtypes(new NamedType(HdfsLoadSpec.class, SCHEME), new NamedType(HdfsFirehoseFactory.class, SCHEME), new NamedType(HdfsInputSource.class, SCHEME)));
    }

    public void configure(Binder binder) {
        MapBinder.newMapBinder((Binder)binder, String.class, SearchableVersionedDataFinder.class).addBinding((Object)SCHEME).to(HdfsFileTimestampVersionFinder.class).in(LazySingleton.class);
        Binders.dataSegmentPusherBinder(binder).addBinding((Object)SCHEME).to(HdfsDataSegmentPusher.class).in(LazySingleton.class);
        Binders.dataSegmentKillerBinder(binder).addBinding((Object)SCHEME).to(HdfsDataSegmentKiller.class).in(LazySingleton.class);
        Configuration conf = new Configuration();
        conf.setClassLoader(this.getClass().getClassLoader());
        ClassLoader currCtxCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            FileSystem.get((Configuration)conf);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currCtxCl);
        }
        if (this.props != null) {
            for (String propName : this.props.stringPropertyNames()) {
                if (!propName.startsWith("hadoop.")) continue;
                conf.set(propName.substring("hadoop.".length()), this.props.getProperty(propName));
            }
        }
        binder.bind(Configuration.class).annotatedWith(Hdfs.class).toInstance((Object)conf);
        JsonConfigProvider.bind(binder, "druid.storage", HdfsDataSegmentPusherConfig.class);
        Binders.taskLogsBinder(binder).addBinding((Object)SCHEME).to(HdfsTaskLogs.class);
        JsonConfigProvider.bind(binder, "druid.indexer.logs", HdfsTaskLogsConfig.class);
        binder.bind(HdfsTaskLogs.class).in(LazySingleton.class);
        JsonConfigProvider.bind(binder, "druid.hadoop.security.kerberos", HdfsKerberosConfig.class);
        binder.bind(HdfsStorageAuthentication.class).in(ManageLifecycle.class);
        LifecycleModule.register(binder, HdfsStorageAuthentication.class);
    }
}

