/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.timeline.partition;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.timeline.Overshadowable;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionChunk;

class AtomicUpdateGroup<T extends Overshadowable<T>>
implements Overshadowable<AtomicUpdateGroup<T>> {
    private final List<PartitionChunk<T>> chunks = new ArrayList<PartitionChunk<T>>();

    AtomicUpdateGroup(PartitionChunk<T> chunk) {
        this.chunks.add(chunk);
    }

    public void add(PartitionChunk<T> chunk) {
        if (this.isFull()) {
            throw new IAE("Can't add more chunk[%s] to atomicUpdateGroup[%s]", chunk, this.chunks);
        }
        if (!this.isEmpty() && !AtomicUpdateGroup.isSameAtomicUpdateGroup(this.chunks.get(0), chunk)) {
            throw new IAE("Can't add chunk[%s] to a different atomicUpdateGroup[%s]", chunk, this.chunks);
        }
        for (PartitionChunk<T> existing : this.chunks) {
            if (!existing.equals(chunk)) continue;
            throw new ISE("Can't add same chunk[%s] again", chunk);
        }
        this.chunks.add(chunk);
    }

    public void remove(PartitionChunk<T> chunk) {
        if (this.chunks.isEmpty()) {
            throw new ISE("Can't remove chunk[%s] from empty atomicUpdateGroup", chunk);
        }
        if (!AtomicUpdateGroup.isSameAtomicUpdateGroup(this.chunks.get(0), chunk)) {
            throw new IAE("Can't remove chunk[%s] from a different atomicUpdateGroup[%s]", chunk, this.chunks);
        }
        this.chunks.remove(chunk);
    }

    public boolean isFull() {
        return !this.isEmpty() && this.chunks.size() == ((Overshadowable)this.chunks.get(0).getObject()).getAtomicUpdateGroupSize();
    }

    public boolean isEmpty() {
        return this.chunks.isEmpty();
    }

    public List<PartitionChunk<T>> getChunks() {
        return this.chunks;
    }

    @Nullable
    PartitionChunk<T> findChunk(int partitionId) {
        return this.chunks.stream().filter(chunk -> chunk.getChunkNumber() == partitionId).findFirst().orElse(null);
    }

    @Override
    public int getStartRootPartitionId() {
        Preconditions.checkState(!this.isEmpty(), "Empty atomicUpdateGroup");
        return ((Overshadowable)this.chunks.get(0).getObject()).getStartRootPartitionId();
    }

    @Override
    public int getEndRootPartitionId() {
        Preconditions.checkState(!this.isEmpty(), "Empty atomicUpdateGroup");
        return ((Overshadowable)this.chunks.get(0).getObject()).getEndRootPartitionId();
    }

    @Override
    public String getVersion() {
        Preconditions.checkState(!this.isEmpty(), "Empty atomicUpdateGroup");
        return ((Overshadowable)this.chunks.get(0).getObject()).getVersion();
    }

    @Override
    public short getMinorVersion() {
        Preconditions.checkState(!this.isEmpty(), "Empty atomicUpdateGroup");
        return ((Overshadowable)this.chunks.get(0).getObject()).getMinorVersion();
    }

    @Override
    public short getAtomicUpdateGroupSize() {
        Preconditions.checkState(!this.isEmpty(), "Empty atomicUpdateGroup");
        return ((Overshadowable)this.chunks.get(0).getObject()).getAtomicUpdateGroupSize();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtomicUpdateGroup that = (AtomicUpdateGroup)o;
        return Objects.equals(this.chunks, that.chunks);
    }

    public int hashCode() {
        return Objects.hash(this.chunks);
    }

    public String toString() {
        return "AtomicUpdateGroup{chunks=" + this.chunks + '}';
    }

    private static <T extends Overshadowable<T>> boolean isSameAtomicUpdateGroup(PartitionChunk<T> c1, PartitionChunk<T> c2) {
        return ((Overshadowable)c1.getObject()).getStartRootPartitionId() == ((Overshadowable)c2.getObject()).getStartRootPartitionId() && ((Overshadowable)c1.getObject()).getEndRootPartitionId() == ((Overshadowable)c2.getObject()).getEndRootPartitionId() && ((Overshadowable)c1.getObject()).getMinorVersion() == ((Overshadowable)c2.getObject()).getMinorVersion() && ((Overshadowable)c1.getObject()).getAtomicUpdateGroupSize() == ((Overshadowable)c2.getObject()).getAtomicUpdateGroupSize();
    }
}

