/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.timeline.partition;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.hash.HashFunction;
import org.apache.hive.druid.com.google.common.hash.Hashing;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.Rows;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpecLookup;

public class HashBasedNumberedShardSpec
extends NumberedShardSpec {
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_32();
    private static final List<String> DEFAULT_PARTITION_DIMENSIONS = ImmutableList.of();
    private final ObjectMapper jsonMapper;
    @JsonIgnore
    private final List<String> partitionDimensions;

    @JsonCreator
    public HashBasedNumberedShardSpec(@JsonProperty(value="partitionNum") int partitionNum, @JsonProperty(value="partitions") int partitions, @JsonProperty(value="partitionDimensions") @Nullable List<String> partitionDimensions, @JacksonInject ObjectMapper jsonMapper) {
        super(partitionNum, partitions);
        this.jsonMapper = jsonMapper;
        this.partitionDimensions = partitionDimensions == null ? DEFAULT_PARTITION_DIMENSIONS : partitionDimensions;
    }

    @JsonProperty(value="partitionDimensions")
    public List<String> getPartitionDimensions() {
        return this.partitionDimensions;
    }

    @Override
    public boolean isCompatible(Class<? extends ShardSpec> other) {
        return other == HashBasedNumberedShardSpec.class;
    }

    @Override
    public boolean isInChunk(long timestamp, InputRow inputRow) {
        return ((long)this.hash(timestamp, inputRow) - (long)this.getPartitionNum()) % (long)this.getPartitions() == 0L;
    }

    protected int hash(long timestamp, InputRow inputRow) {
        List<Object> groupKey = this.getGroupKey(timestamp, inputRow);
        try {
            return HashBasedNumberedShardSpec.hash(this.jsonMapper, groupKey);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    List<Object> getGroupKey(long timestamp, InputRow inputRow) {
        if (this.partitionDimensions.isEmpty()) {
            return Rows.toGroupKey(timestamp, inputRow);
        }
        return Lists.transform(this.partitionDimensions, inputRow::getDimension);
    }

    @VisibleForTesting
    public static int hash(ObjectMapper jsonMapper, List<Object> objects) throws JsonProcessingException {
        return HASH_FUNCTION.hashBytes(jsonMapper.writeValueAsBytes(objects)).asInt();
    }

    @Override
    public String toString() {
        return "HashBasedNumberedShardSpec{partitionNum=" + this.getPartitionNum() + ", partitions=" + this.getPartitions() + ", partitionDimensions=" + this.getPartitionDimensions() + '}';
    }

    @Override
    public ShardSpecLookup getLookup(List<ShardSpec> shardSpecs) {
        return (timestamp, row) -> {
            int index = Math.abs(this.hash(timestamp, row) % this.getPartitions());
            return (ShardSpec)shardSpecs.get(index);
        };
    }
}

