/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.timeline.partition;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Range;
import org.apache.hive.druid.com.google.common.collect.RangeSet;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpecLookup;
import org.apache.hive.druid.org.apache.druid.timeline.partition.StringPartitionChunk;

public class SingleDimensionShardSpec
implements ShardSpec {
    private final String dimension;
    @Nullable
    private final String start;
    @Nullable
    private final String end;
    private final int partitionNum;

    @JsonCreator
    public SingleDimensionShardSpec(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="start") @Nullable String start, @JsonProperty(value="end") @Nullable String end, @JsonProperty(value="partitionNum") int partitionNum) {
        Preconditions.checkArgument(partitionNum >= 0, "partitionNum >= 0");
        this.dimension = Preconditions.checkNotNull(dimension, "dimension");
        this.start = start;
        this.end = end;
        this.partitionNum = partitionNum;
    }

    @JsonProperty(value="dimension")
    public String getDimension() {
        return this.dimension;
    }

    @Nullable
    @JsonProperty(value="start")
    public String getStart() {
        return this.start;
    }

    @Nullable
    @JsonProperty(value="end")
    public String getEnd() {
        return this.end;
    }

    @Override
    @JsonProperty(value="partitionNum")
    public int getPartitionNum() {
        return this.partitionNum;
    }

    @Override
    public ShardSpecLookup getLookup(List<ShardSpec> shardSpecs) {
        return (timestamp, row) -> {
            for (ShardSpec spec : shardSpecs) {
                if (!spec.isInChunk(timestamp, row)) continue;
                return spec;
            }
            throw new ISE("row[%s] doesn't fit in any shard[%s]", row, shardSpecs);
        };
    }

    @Override
    public List<String> getDomainDimensions() {
        return ImmutableList.of(this.dimension);
    }

    private Range<String> getRange() {
        Range<String> range = this.start == null && this.end == null ? Range.all() : (this.start == null ? Range.atMost(this.end) : (this.end == null ? Range.atLeast(this.start) : Range.closed(this.start, this.end)));
        return range;
    }

    @Override
    public boolean possibleInDomain(Map<String, RangeSet<String>> domain) {
        RangeSet<String> rangeSet = domain.get(this.dimension);
        if (rangeSet == null) {
            return true;
        }
        return !rangeSet.subRangeSet(this.getRange()).isEmpty();
    }

    @Override
    public boolean isCompatible(Class<? extends ShardSpec> other) {
        return other == SingleDimensionShardSpec.class;
    }

    @Override
    public <T> PartitionChunk<T> createChunk(T obj) {
        return new StringPartitionChunk<T>(this.start, this.end, this.partitionNum, obj);
    }

    @Override
    public boolean isInChunk(long timestamp, InputRow inputRow) {
        List<String> values = inputRow.getDimension(this.dimension);
        if (values == null || values.size() != 1) {
            return this.checkValue(null);
        }
        return this.checkValue(values.get(0));
    }

    private boolean checkValue(String value) {
        if (value == null) {
            return this.start == null;
        }
        if (this.start == null) {
            return this.end == null || value.compareTo(this.end) < 0;
        }
        return value.compareTo(this.start) >= 0 && (this.end == null || value.compareTo(this.end) < 0);
    }

    public String toString() {
        return "SingleDimensionShardSpec{dimension='" + this.dimension + '\'' + ", start='" + this.start + '\'' + ", end='" + this.end + '\'' + ", partitionNum=" + this.partitionNum + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleDimensionShardSpec that = (SingleDimensionShardSpec)o;
        return this.partitionNum == that.partitionNum && Objects.equals(this.dimension, that.dimension) && Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.start, this.end, this.partitionNum);
    }
}

