/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.jboss.netty.handler.codec.socks;

import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.hive.druid.org.jboss.netty.handler.codec.socks.SocksMessage;
import org.apache.hive.druid.org.jboss.netty.handler.codec.socks.SocksRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SocksInitRequest
extends SocksRequest {
    private final List<SocksMessage.AuthScheme> authSchemes;

    public SocksInitRequest(List<SocksMessage.AuthScheme> authSchemes) {
        super(SocksRequest.SocksRequestType.INIT);
        if (authSchemes == null) {
            throw new NullPointerException("authSchemes");
        }
        this.authSchemes = authSchemes;
    }

    public List<SocksMessage.AuthScheme> getAuthSchemes() {
        return Collections.unmodifiableList(this.authSchemes);
    }

    @Override
    public void encodeAsByteBuf(ChannelBuffer channelBuffer) {
        channelBuffer.writeByte(this.getProtocolVersion().getByteValue());
        channelBuffer.writeByte(this.authSchemes.size());
        for (SocksMessage.AuthScheme authScheme : this.authSchemes) {
            channelBuffer.writeByte(authScheme.getByteValue());
        }
    }
}

