/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.commands;

import java.util.function.Function;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.MetaWrapperException;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionState;
import org.apache.hadoop.hive.metastore.txn.jdbc.ParameterizedCommand;
import org.apache.hadoop.hive.metastore.utils.StringableMap;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class InsertCompactionRequestCommand
implements ParameterizedCommand {
    private final long id;
    private final CompactionState compactionState;
    private final CompactionRequest rqst;
    private Long highestWriteId = null;
    private Long txnId = null;

    public InsertCompactionRequestCommand(long id, CompactionState compactionState, CompactionRequest rqst) {
        this.id = id;
        this.compactionState = compactionState;
        this.rqst = rqst;
    }

    public InsertCompactionRequestCommand withTxnDetails(long highestWriteId, long txnId) {
        this.highestWriteId = highestWriteId;
        this.txnId = txnId;
        return this;
    }

    @Override
    public Function<Integer, Boolean> resultPolicy() {
        return ParameterizedCommand.EXACTLY_ONE_ROW;
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        return "INSERT INTO \"COMPACTION_QUEUE\" (\"CQ_ID\", \"CQ_DATABASE\", \"CQ_TABLE\", \"CQ_PARTITION\", \"CQ_STATE\", \"CQ_TYPE\", \"CQ_POOL_NAME\", \"CQ_NUMBER_OF_BUCKETS\", \"CQ_ORDER_BY\", \"CQ_TBLPROPERTIES\", \"CQ_RUN_AS\", \"CQ_INITIATOR_ID\", \"CQ_INITIATOR_VERSION\", \"CQ_HIGHEST_WRITE_ID\", \"CQ_TXN_ID\", \"CQ_ENQUEUE_TIME\") VALUES(:id, :dbName, :tableName, :partition, :state, :type, :poolName, :buckets, :orderBy, :tblProperties, :runAs, :initiatorId, :initiatorVersion, :highestWriteId, :txnId, " + TxnUtils.getEpochFn(databaseProduct) + ")";
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        try {
            return new MapSqlParameterSource().addValue("id", (Object)this.id).addValue("dbName", (Object)this.rqst.getDbname(), 12).addValue("tableName", (Object)this.rqst.getTablename(), 12).addValue("partition", (Object)this.rqst.getPartitionname(), 12).addValue("state", (Object)this.compactionState.getSqlConst(), 12).addValue("type", (Object)TxnUtils.thriftCompactionType2DbType(this.rqst.getType()), 12).addValue("poolName", (Object)this.rqst.getPoolName(), 12).addValue("buckets", this.rqst.isSetNumberOfBuckets() ? Integer.valueOf(this.rqst.getNumberOfBuckets()) : null, 4).addValue("orderBy", (Object)this.rqst.getOrderByClause(), 12).addValue("tblProperties", (Object)(this.rqst.getProperties() == null ? null : new StringableMap(this.rqst.getProperties())), 12).addValue("runAs", (Object)this.rqst.getRunas(), 12).addValue("initiatorId", (Object)this.rqst.getInitiatorId(), 12).addValue("initiatorVersion", (Object)this.rqst.getInitiatorVersion(), 12).addValue("highestWriteId", (Object)this.highestWriteId, -5).addValue("txnId", (Object)this.txnId, -5);
        }
        catch (MetaException e) {
            throw new MetaWrapperException(e);
        }
    }
}

