/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.add;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Add Partition", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class AlterTableAddPartitionDesc
implements DDLDesc.DDLDescWithWriteId,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String dbName;
    private final String tableName;
    private final boolean ifNotExists;
    private final List<PartitionDesc> partitions;
    private Long writeId;
    private ReplicationSpec replicationSpec = null;

    public AlterTableAddPartitionDesc(String dbName, String tableName, boolean ifNotExists, List<PartitionDesc> partitions) {
        this.dbName = dbName;
        this.tableName = tableName;
        this.ifNotExists = ifNotExists;
        this.partitions = partitions;
    }

    @Explain(displayName="db name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getDbName() {
        return this.dbName;
    }

    @Explain(displayName="table name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getTableName() {
        return this.tableName;
    }

    @Explain(displayName="if not exists", displayOnlyOnTrue=true, explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    @Explain(displayName="partitions", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public List<PartitionDesc> getPartitions() {
        return this.partitions;
    }

    public void setReplicationSpec(ReplicationSpec replicationSpec) {
        this.replicationSpec = replicationSpec;
    }

    public ReplicationSpec getReplicationSpec() {
        if (this.replicationSpec == null) {
            this.replicationSpec = new ReplicationSpec();
        }
        return this.replicationSpec;
    }

    @Override
    public void setWriteId(long writeId) {
        this.writeId = writeId;
    }

    @Override
    public String getFullTableName() {
        return AcidUtils.getFullTableName(this.dbName, this.tableName);
    }

    @Override
    public boolean mayNeedWriteId() {
        return true;
    }

    @Explain(displayName="Partition", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public static class PartitionDesc {
        private final Map<String, String> partitionSpec;
        private String location;
        private final Map<String, String> params;
        private final String inputFormat;
        private final String outputFormat;
        private final int numBuckets;
        private final List<FieldSchema> columns;
        private final String serializationLib;
        private final Map<String, String> serdeParams;
        private final List<String> bucketColumns;
        private final List<Order> sortColumns;
        private final ColumnStatistics columnStats;
        private final long writeId;

        public PartitionDesc(Map<String, String> partitionSpec, String location, Map<String, String> params) {
            this(partitionSpec, location, params, null, null, -1, null, null, null, null, null, null, -1L);
        }

        public PartitionDesc(Map<String, String> partitionSpec, String location, Map<String, String> params, String inputFormat, String outputFormat, int numBuckets, List<FieldSchema> columns, String serializationLib, Map<String, String> serdeParams, List<String> bucketColumns, List<Order> sortColumns, ColumnStatistics columnStats, long writeId) {
            this.partitionSpec = partitionSpec;
            this.location = location;
            this.params = params;
            this.inputFormat = inputFormat;
            this.outputFormat = outputFormat;
            this.numBuckets = numBuckets;
            this.columns = columns;
            this.serializationLib = serializationLib;
            this.serdeParams = serdeParams;
            this.bucketColumns = bucketColumns;
            this.sortColumns = sortColumns;
            this.columnStats = columnStats;
            this.writeId = writeId;
        }

        public Map<String, String> getPartSpec() {
            return this.partitionSpec;
        }

        @Explain(displayName="partition spec", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getPartSpecForExplain() {
            return this.partitionSpec.toString();
        }

        @Explain(displayName="location", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public Map<String, String> getPartParams() {
            return this.params;
        }

        public void addPartParams(Map<String, String> partParams) {
            if (this.params != null) {
                this.params.putAll(partParams);
            }
        }

        @Explain(displayName="params", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getPartParamsForExplain() {
            return this.params.toString();
        }

        @Explain(displayName="input format", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getInputFormat() {
            return this.inputFormat;
        }

        @Explain(displayName="output format", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getOutputFormat() {
            return this.outputFormat;
        }

        public int getNumBuckets() {
            return this.numBuckets;
        }

        @Explain(displayName="num buckets", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public Integer getNumBucketsExplain() {
            return this.numBuckets == -1 ? null : Integer.valueOf(this.numBuckets);
        }

        @Explain(displayName="columns", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<FieldSchema> getCols() {
            return this.columns;
        }

        @Explain(displayName="serialization lib", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getSerializationLib() {
            return this.serializationLib;
        }

        @Explain(displayName="serde params", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public Map<String, String> getSerdeParams() {
            return this.serdeParams;
        }

        @Explain(displayName="bucket columns", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> getBucketCols() {
            return this.bucketColumns;
        }

        @Explain(displayName="sort columns", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<Order> getSortCols() {
            return this.sortColumns;
        }

        @Explain(displayName="column stats", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public ColumnStatistics getColStats() {
            return this.columnStats;
        }

        public long getWriteId() {
            return this.writeId;
        }
    }
}

