/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.WindowFunctionDescription;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hive.common.util.AnnotationUtils;

public class WindowFunctionInfo
extends FunctionInfo {
    private final boolean supportsWindow;
    private final boolean pivotResult;
    private final boolean impliesOrder;
    private final boolean orderedAggregate;
    private final boolean supportsNullTreatment;

    public WindowFunctionInfo(FunctionInfo.FunctionType functionType, String functionName, GenericUDAFResolver resolver, FunctionInfo.FunctionResource[] resources) {
        super(functionType, functionName, resolver, resources);
        WindowFunctionDescription def = (WindowFunctionDescription)AnnotationUtils.getAnnotation(resolver.getClass(), WindowFunctionDescription.class);
        this.supportsWindow = def == null ? true : def.supportsWindow();
        this.pivotResult = def == null ? false : def.pivotResult();
        this.impliesOrder = def == null ? false : def.impliesOrder();
        this.orderedAggregate = def == null ? false : def.orderedAggregate();
        this.supportsNullTreatment = def == null ? false : def.supportsNullTreatment();
    }

    public boolean isSupportsWindow() {
        return this.supportsWindow;
    }

    public boolean isPivotResult() {
        return this.pivotResult;
    }

    public boolean isImpliesOrder() {
        return this.impliesOrder;
    }

    public boolean isOrderedAggregate() {
        return this.orderedAggregate;
    }

    public boolean isSupportsNullTreatment() {
        return this.supportsNullTreatment;
    }
}

