/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.events.PreAlterDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterDatabaseEvent
extends HiveMetaStoreAuthorizableEvent {
    private static final Logger LOG = LoggerFactory.getLogger(AlterDatabaseEvent.class);
    private String COMMAND_STR = "alter database";

    public AlterDatabaseEvent(PreEventContext preEventContext) {
        super(preEventContext);
    }

    @Override
    public HiveMetaStoreAuthzInfo getAuthzContext() {
        HiveMetaStoreAuthzInfo ret = new HiveMetaStoreAuthzInfo(this.preEventContext, this.getOperationType(), this.getInputHObjs(), this.getOutputHObjs(), this.COMMAND_STR);
        return ret;
    }

    private HiveOperationType getOperationType() {
        PreAlterDatabaseEvent event = (PreAlterDatabaseEvent)this.preEventContext;
        Database database = event.getNewDatabase();
        Database oldDatabase = event.getOldDatabase();
        String newUri = database != null ? database.getLocationUri() : "";
        String oldUri = oldDatabase != null ? oldDatabase.getLocationUri() : "";
        return StringUtils.equals((CharSequence)oldUri, (CharSequence)newUri) ? HiveOperationType.ALTERDATABASE : HiveOperationType.ALTERDATABASE_LOCATION;
    }

    private List<HivePrivilegeObject> getInputHObjs() {
        return Collections.emptyList();
    }

    private List<HivePrivilegeObject> getOutputHObjs() {
        LOG.debug("==> AlterDatabaseEvent.getOutputHObjs()");
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        PreAlterDatabaseEvent event = (PreAlterDatabaseEvent)this.preEventContext;
        Database database = event.getNewDatabase();
        if (database != null) {
            String newUri;
            ret.add(this.getHivePrivilegeObject(database));
            String string = newUri = database != null ? database.getLocationUri() : "";
            if (StringUtils.isNotEmpty((CharSequence)newUri)) {
                ret.add(this.getHivePrivilegeObjectDfsUri(newUri));
            }
            this.COMMAND_STR = this.buildCommandString(this.COMMAND_STR, database);
            LOG.debug("<== AlterDatabaseEvent.getOutputHObjs(): ret={}", ret);
        }
        return ret;
    }

    private String buildCommandString(String cmdStr, Database db) {
        Object ret = cmdStr;
        if (db != null) {
            String dbName = db.getName();
            ret = (String)ret + (String)(StringUtils.isNotEmpty((CharSequence)dbName) ? " " + dbName : "");
        }
        return ret;
    }
}

