/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor.handler;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.metrics.PerfLogger;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorUtil;
import org.apache.hadoop.hive.ql.txn.compactor.FSRemover;
import org.apache.hadoop.hive.ql.txn.compactor.MetadataCache;
import org.apache.hadoop.hive.ql.txn.compactor.handler.TaskHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AbortedTxnCleaner
extends TaskHandler {
    private static final Logger LOG = LoggerFactory.getLogger((String)AbortedTxnCleaner.class.getName());

    public AbortedTxnCleaner(HiveConf conf, TxnStore txnHandler, MetadataCache metadataCache, boolean metricsEnabled, FSRemover fsRemover) {
        super(conf, txnHandler, metadataCache, metricsEnabled, fsRemover);
    }

    @Override
    public List<Runnable> getTasks(HiveConf conf) throws MetaException {
        int abortedThreshold = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD);
        long abortedTimeThreshold = HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_TIME_THRESHOLD, (TimeUnit)TimeUnit.MILLISECONDS);
        List readyToCleanAborts = this.txnHandler.findReadyToCleanAborts(abortedTimeThreshold, abortedThreshold);
        if (!readyToCleanAborts.isEmpty()) {
            return readyToCleanAborts.stream().map(info -> CompactorUtil.ThrowingRunnable.unchecked(() -> this.clean((CompactionInfo)info, this.metricsEnabled))).toList();
        }
        return Collections.emptyList();
    }

    private void clean(CompactionInfo info, boolean metricsEnabled) throws MetaException, InterruptedException {
        LOG.info("Starting cleaning for {}", (Object)info);
        PerfLogger perfLogger = PerfLogger.getPerfLogger((boolean)false);
        String cleanerMetric = "compaction_cleaner_cycle_";
        try {
            if (metricsEnabled) {
                perfLogger.perfLogBegin(AbortedTxnCleaner.class.getName(), cleanerMetric);
            }
            Partition p = null;
            Table t = this.resolveTable(info);
            if (Objects.isNull(t)) {
                LOG.info("Unable to find table {}, assuming it was dropped.", (Object)info.getFullTableName());
                this.txnHandler.markCleaned(info);
                return;
            }
            if (!Objects.isNull(info.partName) && Objects.isNull(p = this.resolvePartition(info.dbname, info.tableName, info.partName))) {
                LOG.info("Unable to find partition {}, assuming it was dropped.", (Object)info.getFullPartitionName());
                this.txnHandler.markCleaned(info);
                return;
            }
            String location = CompactorUtil.resolveStorageDescriptor(t, p).getLocation();
            info.runAs = TxnUtils.findUserToRunAs((String)location, (Table)t, (Configuration)this.getConf());
            this.abortCleanUsingAcidDir(info, t, location);
        }
        catch (InterruptedException e) {
            LOG.error("Caught an interrupted exception when cleaning, unable to complete cleaning of {} due to {}", (Object)info, (Object)e.getMessage());
            this.handleCleanerAttemptFailure(info, e.getMessage());
            throw e;
        }
        catch (Exception e) {
            LOG.error("Caught exception when cleaning, unable to complete cleaning of {} due to {}", (Object)info, (Object)e.getMessage());
            this.handleCleanerAttemptFailure(info, e.getMessage());
            throw new MetaException(e.getMessage());
        }
        finally {
            if (metricsEnabled) {
                perfLogger.perfLogEnd(AbortedTxnCleaner.class.getName(), cleanerMetric);
            }
        }
    }

    private void abortCleanUsingAcidDir(CompactionInfo info, Table table, String location) throws Exception {
        ValidTxnList validTxnList = TxnUtils.createValidTxnListForCleaner((GetOpenTxnsResponse)this.getOpenTxns(), (long)info.minOpenWriteTxnId, (boolean)true);
        this.getConf().set("hive.txn.valid.txns", validTxnList.writeToString());
        ValidReaderWriteIdList validWriteIdList = this.getValidCleanerWriteIdList(info, validTxnList);
        LOG.debug("Cleaning based on writeIdList: {}", (Object)validWriteIdList);
        info.highestWriteId = Math.min(Objects.isNull(validWriteIdList.getMinOpenWriteId()) ? Long.MAX_VALUE : validWriteIdList.getMinOpenWriteId() - 1L, validWriteIdList.getHighWatermark());
        boolean success = this.cleanAndVerifyObsoleteDirectories(info, location, validWriteIdList, table);
        if (success || CompactorUtil.isDynPartAbort(table, info.partName)) {
            this.txnHandler.markCleaned(info);
        } else {
            LOG.warn("Leaving aborted entry {} in TXN_COMPONENTS table.", (Object)info);
        }
    }
}

