/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.ignite.internal.sql.engine.QueryCancelledException;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.util.AsyncCursor;
import org.apache.ignite.lang.CursorClosedException;
import org.jetbrains.annotations.Nullable;

public class AsyncRootNode<InRowT, OutRowT>
implements Downstream<InRowT>,
AsyncCursor<OutRowT> {
    private final CompletableFuture<Void> cancelFut = new CompletableFuture();
    private final Object lock = new Object();
    private final AtomicReference<Throwable> ex = new AtomicReference();
    private final AbstractNode<InRowT> source;
    private final Function<InRowT, OutRowT> converter;
    private final Queue<OutRowT> buff = new ArrayDeque<OutRowT>(512);
    private final AtomicBoolean taskScheduled = new AtomicBoolean();
    private final Queue<PendingRequest<OutRowT>> pendingRequests = new ConcurrentLinkedQueue<PendingRequest<OutRowT>>();
    private final CompletableFuture<Void> prefetchFut = new CompletableFuture();
    private volatile boolean closed = false;
    private int waiting;

    public AsyncRootNode(AbstractNode<InRowT> source, Function<InRowT, OutRowT> converter) {
        this.source = source;
        this.converter = converter;
    }

    @Override
    public void push(InRowT row) throws Exception {
        assert (this.waiting > 0) : this.waiting;
        this.buff.add(this.converter.apply(row));
        if (--this.waiting == 0) {
            this.completePrefetchFuture(null);
            this.flush();
        }
    }

    @Override
    public void end() throws Exception {
        assert (this.waiting > 0) : this.waiting;
        this.waiting = -1;
        this.completePrefetchFuture(null);
        this.flush();
    }

    @Override
    public void onError(Throwable e) {
        if (this.closed) {
            return;
        }
        if (!this.ex.compareAndSet(null, e)) {
            this.ex.get().addSuppressed(e);
        }
        this.closeAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<AsyncCursor.BatchedResult<OutRowT>> requestNextAsync(int rows) {
        CompletableFuture<AsyncCursor.BatchedResult<OutRowT>> next = new CompletableFuture<AsyncCursor.BatchedResult<OutRowT>>();
        Object object = this.lock;
        synchronized (object) {
            Throwable t = this.ex.get();
            if (t != null) {
                next.completeExceptionally(t);
                return next;
            }
            if (this.closed) {
                next.completeExceptionally((Throwable)new CursorClosedException());
                return next;
            }
            this.pendingRequests.add(new PendingRequest<OutRowT>(rows, next));
            this.scheduleTask();
        }
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> closeAsync() {
        if (!this.closed) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.closed) {
                    Object th = this.ex.get();
                    if (!this.pendingRequests.isEmpty()) {
                        if (th == null) {
                            th = new QueryCancelledException();
                        }
                        Throwable th0 = th;
                        this.pendingRequests.forEach(req -> req.fut.completeExceptionally(th0));
                        this.pendingRequests.clear();
                    }
                    this.source.context().execute(() -> {
                        try {
                            this.source.close();
                            this.cancelFut.complete(null);
                        }
                        catch (Throwable t) {
                            this.cancelFut.completeExceptionally(t);
                            throw t;
                        }
                    }, this.source::onError);
                    this.completePrefetchFuture((Throwable)th);
                    this.closed = true;
                }
            }
        }
        return this.cancelFut;
    }

    public CompletableFuture<Void> startPrefetch() {
        assert (this.source.context().description().prefetch());
        if (this.waiting == 0) {
            try {
                this.source.checkState();
                this.waiting = 512;
                this.source.request(512);
            }
            catch (Exception ex) {
                this.onError(ex);
            }
        }
        return this.prefetchFut;
    }

    public boolean isClosed() {
        return this.cancelFut.isDone();
    }

    private void flush() throws Exception {
        PendingRequest<OutRowT> currentReq = this.pendingRequests.peek();
        if (currentReq == null) {
            return;
        }
        while (!this.buff.isEmpty() && currentReq.buff.size() < currentReq.requested) {
            currentReq.buff.add(this.buff.remove());
        }
        HasMore hasMore = this.waiting == -1 && this.buff.isEmpty() ? HasMore.NO : (!this.buff.isEmpty() ? HasMore.YES : HasMore.UNCERTAIN);
        if (currentReq.buff.size() == currentReq.requested && hasMore != HasMore.UNCERTAIN || hasMore == HasMore.NO) {
            this.pendingRequests.poll();
            currentReq.fut.complete(new AsyncCursor.BatchedResult(currentReq.buff, hasMore == HasMore.YES));
        }
        if (this.buff.isEmpty()) {
            if (this.waiting == 0) {
                this.waiting = 512;
                this.source.request(512);
            } else if (this.waiting == -1) {
                assert (hasMore == HasMore.NO) : hasMore;
                this.closeAsync();
            }
        } else if (!this.pendingRequests.isEmpty()) {
            this.scheduleTask();
        }
    }

    private void scheduleTask() {
        if (!this.pendingRequests.isEmpty() && this.taskScheduled.compareAndSet(false, true)) {
            this.source.execute(() -> {
                this.taskScheduled.set(false);
                this.flush();
            });
        }
    }

    private void completePrefetchFuture(@Nullable Throwable ex) {
        if (!this.prefetchFut.isDone()) {
            if (ex != null) {
                this.prefetchFut.completeExceptionally(ex);
            } else {
                this.prefetchFut.complete(null);
            }
        }
    }

    private static class PendingRequest<OutRowT> {
        private final CompletableFuture<AsyncCursor.BatchedResult<OutRowT>> fut;
        private final int requested;
        private final List<OutRowT> buff;

        private PendingRequest(int requested, CompletableFuture<AsyncCursor.BatchedResult<OutRowT>> fut) {
            this.requested = requested;
            this.fut = fut;
            this.buff = new ArrayList<OutRowT>(requested);
        }
    }

    private static enum HasMore {
        YES,
        NO,
        UNCERTAIN;

    }
}

