/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.schema;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Comparator;
import java.util.List;
import org.apache.ignite3.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite3.internal.catalog.descriptors.CatalogColumnCollation;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.schema.BinaryTupleComparatorUtils;
import org.apache.ignite3.internal.schema.BinaryTuplePrefix;
import org.apache.ignite3.internal.schema.UnsafeByteBufferAccessor;
import org.apache.ignite3.internal.type.NativeType;

public class BinaryTupleComparator
implements Comparator<ByteBuffer> {
    private final List<CatalogColumnCollation> columnCollations;
    private final List<NativeType> columnTypes;

    public BinaryTupleComparator(List<CatalogColumnCollation> columnCollations, List<NativeType> columnTypes) {
        this.columnCollations = columnCollations;
        this.columnTypes = columnTypes;
    }

    @Override
    public int compare(ByteBuffer buffer1, ByteBuffer buffer2) {
        assert (buffer1.order() == ByteOrder.LITTLE_ENDIAN);
        assert (buffer2.order() == ByteOrder.LITTLE_ENDIAN);
        boolean isBuffer1Prefix = BinaryTupleComparatorUtils.isFlagSet(buffer1, 8);
        boolean isBuffer2Prefix = BinaryTupleComparatorUtils.isFlagSet(buffer2, 8);
        int numElements = this.columnTypes.size();
        BinaryTupleReader tuple1 = isBuffer1Prefix ? new BinaryTuplePrefix(numElements, buffer1) : new BinaryTuple(numElements, buffer1, UnsafeByteBufferAccessor::new);
        BinaryTupleReader tuple2 = isBuffer2Prefix ? new BinaryTuplePrefix(numElements, buffer2) : new BinaryTuple(numElements, buffer2, UnsafeByteBufferAccessor::new);
        int columnsToCompare = Math.min(tuple1.elementCount(), tuple2.elementCount());
        assert (columnsToCompare <= numElements);
        for (int i = 0; i < columnsToCompare; ++i) {
            int res = this.compareField(i, tuple1, tuple2);
            if (res == 0) continue;
            return res;
        }
        if (isBuffer1Prefix == isBuffer2Prefix) {
            return 0;
        }
        if (isBuffer1Prefix) {
            return BinaryTupleComparatorUtils.equalityFlag(buffer1);
        }
        return -BinaryTupleComparatorUtils.equalityFlag(buffer2);
    }

    private int compareField(int colIdx, BinaryTupleReader tuple1, BinaryTupleReader tuple2) {
        CatalogColumnCollation collation = this.columnCollations.get(colIdx);
        boolean tuple1HasNull = tuple1.hasNullValue(colIdx);
        boolean tuple2HasNull = tuple2.hasNullValue(colIdx);
        if (tuple1HasNull && tuple2HasNull) {
            return 0;
        }
        if (tuple1HasNull || tuple2HasNull) {
            return collation.nullsFirst() == tuple1HasNull ? -1 : 1;
        }
        NativeType nativeType = this.columnTypes.get(colIdx);
        int res = BinaryTupleComparatorUtils.compareFieldValue(nativeType.spec(), tuple1, tuple2, colIdx);
        return collation.asc() ? res : -res;
    }
}

