/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.types;

import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.NumericInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IntegerIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.NumericIndexKey;
import org.apache.ignite.internal.pagemem.PageUtils;

public class IntegerInlineIndexKeyType
extends NumericInlineIndexKeyType<IntegerIndexKey> {
    public IntegerInlineIndexKeyType() {
        super(IndexKeyType.INT, (short)4);
    }

    @Override
    protected int put0(long pageAddr, int off, IntegerIndexKey key, int maxSize) {
        PageUtils.putByte(pageAddr, off, (byte)this.type().code());
        PageUtils.putInt(pageAddr, off + 1, (Integer)key.key());
        return this.keySize + 1;
    }

    @Override
    protected IntegerIndexKey get0(long pageAddr, int off) {
        int key = PageUtils.getInt(pageAddr, off + 1);
        return new IntegerIndexKey(key);
    }

    @Override
    public int compare0(long pageAddr, int off, IndexKey key) {
        int val = PageUtils.getInt(pageAddr, off + 1);
        return -Integer.signum(((NumericIndexKey)key).compareTo(val));
    }
}

