/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.bifromq.mqtt.handler.condition.Condition;
import org.apache.bifromq.mqtt.handler.condition.InboundResourceCondition;
import org.apache.bifromq.plugin.eventcollector.Event;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.eventcollector.OutOfTenantResource;
import org.apache.bifromq.plugin.eventcollector.ThreadLocalEventPool;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ResourceThrottled;
import org.apache.bifromq.sysprops.props.MaxSlowDownTimeoutSeconds;
import org.apache.bifromq.type.ClientInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalSlowDownHandler
extends ChannelInboundHandlerAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConditionalSlowDownHandler.class);
    public static final String NAME = "SlowDownHandler";
    private static final long MAX_SLOWDOWN_TIME = Duration.ofSeconds(((Integer)MaxSlowDownTimeoutSeconds.INSTANCE.get()).intValue()).toNanos();
    private final Condition slowDownCondition;
    private final Supplier<Long> nanoProvider;
    private final IEventCollector eventCollector;
    private final ClientInfo clientInfo;
    private ChannelHandlerContext ctx;
    private ScheduledFuture<?> resumeTask;
    private long slowDownAt = Long.MAX_VALUE;

    public ConditionalSlowDownHandler(Condition slowDownCondition, IEventCollector eventCollector, Supplier<Long> nanoProvider, ClientInfo clientInfo) {
        this.slowDownCondition = slowDownCondition;
        this.eventCollector = eventCollector;
        this.nanoProvider = nanoProvider;
        this.clientInfo = clientInfo;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.ctx = ctx;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (this.resumeTask != null) {
            this.resumeTask.cancel(true);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.slowDownCondition.meet()) {
            ctx.channel().config().setAutoRead(false);
            this.slowDownAt = this.nanoProvider.get();
            this.scheduleResumeRead();
        }
        ctx.fireChannelRead(msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        if (!this.slowDownCondition.meet()) {
            ctx.channel().config().setAutoRead(true);
            this.slowDownAt = Long.MAX_VALUE;
        } else {
            this.closeIfNeeded();
        }
        ctx.fireChannelReadComplete();
    }

    private void scheduleResumeRead() {
        if (this.resumeTask == null || this.resumeTask.isDone()) {
            this.resumeTask = this.ctx.executor().schedule(this::resumeRead, ThreadLocalRandom.current().nextLong(100L, 1001L), TimeUnit.MILLISECONDS);
        }
    }

    private void resumeRead() {
        if (!this.slowDownCondition.meet()) {
            if (!this.ctx.channel().config().isAutoRead()) {
                this.ctx.channel().config().setAutoRead(true);
                this.ctx.read();
                this.slowDownAt = Long.MAX_VALUE;
            }
        } else if (!this.closeIfNeeded()) {
            this.resumeTask = null;
            this.scheduleResumeRead();
        }
    }

    private boolean closeIfNeeded() {
        if (this.nanoProvider.get() - this.slowDownAt > MAX_SLOWDOWN_TIME) {
            this.ctx.close();
            if (this.slowDownCondition.meet()) {
                if (this.slowDownCondition instanceof InboundResourceCondition) {
                    this.eventCollector.report((Event)((OutOfTenantResource)ThreadLocalEventPool.getLocal(OutOfTenantResource.class)).reason(this.slowDownCondition.toString()).clientInfo(this.clientInfo));
                }
                this.eventCollector.report((Event)((ResourceThrottled)ThreadLocalEventPool.getLocal(ResourceThrottled.class)).reason(this.slowDownCondition.toString()).clientInfo(this.clientInfo));
            }
            return true;
        }
        return false;
    }
}

