/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.core.internal;

import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bifromq.basecrdt.core.api.CausalCRDTType;
import org.apache.bifromq.basecrdt.core.api.EWFlagOperation;
import org.apache.bifromq.basecrdt.core.api.IEWFlag;
import org.apache.bifromq.basecrdt.core.api.IEWFlagInflater;
import org.apache.bifromq.basecrdt.core.internal.CausalCRDT;
import org.apache.bifromq.basecrdt.core.internal.CausalCRDTInflater;
import org.apache.bifromq.basecrdt.core.internal.DotSet;
import org.apache.bifromq.basecrdt.core.internal.EWFlag;
import org.apache.bifromq.basecrdt.core.internal.EWFlagCoalesceOperation;
import org.apache.bifromq.basecrdt.core.internal.ICoalesceOperation;
import org.apache.bifromq.basecrdt.core.internal.IDotSet;
import org.apache.bifromq.basecrdt.core.internal.IReplicaStateLattice;
import org.apache.bifromq.basecrdt.proto.Replica;

class EWFlagInflater
extends CausalCRDTInflater<IDotSet, EWFlagOperation, IEWFlag>
implements IEWFlagInflater {
    EWFlagInflater(String storeId, Replica replica, IReplicaStateLattice stateLattice, ScheduledExecutorService executor, Duration inflationInterval, String ... tags) {
        super(storeId, replica, stateLattice, executor, inflationInterval, tags);
    }

    @Override
    protected IEWFlag newCRDT(Replica replica, IDotSet dotStore, CausalCRDT.CRDTOperationExecutor<EWFlagOperation> executor) {
        return new EWFlag(replica, () -> dotStore, executor);
    }

    @Override
    public CausalCRDTType type() {
        return CausalCRDTType.ewflag;
    }

    @Override
    protected ICoalesceOperation<IDotSet, EWFlagOperation> startCoalescing(EWFlagOperation op) {
        return new EWFlagCoalesceOperation(this.id().getId(), op);
    }

    @Override
    protected Class<? extends IDotSet> dotStoreType() {
        return DotSet.class;
    }
}

