/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.server.scheduler;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import lombok.Generated;
import org.apache.bifromq.basekv.client.IMutationPipeline;
import org.apache.bifromq.basekv.client.exception.BadVersionException;
import org.apache.bifromq.basekv.client.exception.TryLaterException;
import org.apache.bifromq.basekv.client.scheduler.BatchMutationCall;
import org.apache.bifromq.basekv.client.scheduler.MutationCallBatcherKey;
import org.apache.bifromq.basekv.store.proto.RWCoProcInput;
import org.apache.bifromq.basekv.store.proto.RWCoProcOutput;
import org.apache.bifromq.baserpc.client.exception.ServerNotFoundException;
import org.apache.bifromq.basescheduler.ICallTask;
import org.apache.bifromq.dist.rpc.proto.BatchMatchReply;
import org.apache.bifromq.dist.rpc.proto.BatchMatchRequest;
import org.apache.bifromq.dist.rpc.proto.DistServiceRWCoProcInput;
import org.apache.bifromq.dist.rpc.proto.MatchReply;
import org.apache.bifromq.dist.rpc.proto.MatchRequest;
import org.apache.bifromq.dist.rpc.proto.MatchRoute;
import org.apache.bifromq.dist.rpc.proto.TenantOption;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.plugin.settingprovider.Setting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchMatchCall
extends BatchMutationCall<MatchRequest, MatchReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchMatchCall.class);
    private final ISettingProvider settingProvider;

    BatchMatchCall(IMutationPipeline pipeline, ISettingProvider settingProvider, MutationCallBatcherKey batcherKey) {
        super(pipeline, batcherKey);
        this.settingProvider = settingProvider;
    }

    protected RWCoProcInput makeBatch(Iterable<ICallTask<MatchRequest, MatchReply, MutationCallBatcherKey>> callTasks) {
        BatchMatchRequest.Builder reqBuilder = BatchMatchRequest.newBuilder();
        HashMap<String, BatchMatchRequest.TenantBatch.Builder> builders = new HashMap<String, BatchMatchRequest.TenantBatch.Builder>();
        for (MatchRequest matchReq : Iterables.transform(callTasks, ICallTask::call)) {
            builders.computeIfAbsent(matchReq.getTenantId(), k -> BatchMatchRequest.TenantBatch.newBuilder().setOption(TenantOption.newBuilder().setMaxReceiversPerSharedSubGroup(((Integer)this.settingProvider.provide(Setting.MaxSharedGroupMembers, matchReq.getTenantId())).intValue()).build())).addRoute(MatchRoute.newBuilder().setMatcher(matchReq.getMatcher()).setReceiverId(matchReq.getReceiverId()).setDelivererKey(matchReq.getDelivererKey()).setBrokerId(matchReq.getBrokerId()).setIncarnation(matchReq.getIncarnation()).build());
        }
        builders.forEach((t, builder) -> reqBuilder.putRequests(t, builder.build()));
        long reqId = System.nanoTime();
        return RWCoProcInput.newBuilder().setDistService(DistServiceRWCoProcInput.newBuilder().setBatchMatch(reqBuilder.setReqId(reqId).build()).build()).build();
    }

    protected void handleException(ICallTask<MatchRequest, MatchReply, MutationCallBatcherKey> callTask, Throwable e) {
        if (e instanceof ServerNotFoundException) {
            callTask.resultPromise().complete(MatchReply.newBuilder().setReqId(((MatchRequest)callTask.call()).getReqId()).setResult(MatchReply.Result.TRY_LATER).build());
            return;
        }
        if (e instanceof BadVersionException) {
            callTask.resultPromise().complete(MatchReply.newBuilder().setReqId(((MatchRequest)callTask.call()).getReqId()).setResult(MatchReply.Result.TRY_LATER).build());
            return;
        }
        if (e instanceof TryLaterException) {
            callTask.resultPromise().complete(MatchReply.newBuilder().setReqId(((MatchRequest)callTask.call()).getReqId()).setResult(MatchReply.Result.TRY_LATER).build());
            return;
        }
        callTask.resultPromise().completeExceptionally(e);
    }

    protected void handleOutput(Queue<ICallTask<MatchRequest, MatchReply, MutationCallBatcherKey>> batchedTasks, RWCoProcOutput output) {
        ICallTask<MatchRequest, MatchReply, MutationCallBatcherKey> callTask;
        BatchMatchReply reply = output.getDistService().getBatchMatch();
        HashMap<String, List> tasksByTenant = new HashMap<String, List>();
        while ((callTask = batchedTasks.poll()) != null) {
            tasksByTenant.computeIfAbsent(((MatchRequest)callTask.call()).getTenantId(), k -> new ArrayList()).add(callTask);
        }
        for (String tenantId : tasksByTenant.keySet()) {
            List tasks = (List)tasksByTenant.get(tenantId);
            List codes = ((BatchMatchReply.TenantBatch)reply.getResultsMap().get(tenantId)).getCodeList();
            assert (tasks.size() == codes.size());
            for (int i = 0; i < tasks.size(); ++i) {
                MatchReply.Result matchResult = switch ((BatchMatchReply.TenantBatch.Code)codes.get(i)) {
                    case BatchMatchReply.TenantBatch.Code.OK -> MatchReply.Result.OK;
                    case BatchMatchReply.TenantBatch.Code.EXCEED_LIMIT -> MatchReply.Result.EXCEED_LIMIT;
                    default -> {
                        log.error("Unexpected match result: {}", codes.get(i));
                        yield MatchReply.Result.ERROR;
                    }
                };
                ((ICallTask)tasks.get(i)).resultPromise().complete(MatchReply.newBuilder().setReqId(((MatchRequest)((ICallTask)tasks.get(i)).call()).getReqId()).setResult(matchResult).build());
            }
        }
    }
}

