/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon;

import org.apache.fluss.types.ArrayType;
import org.apache.fluss.types.BigIntType;
import org.apache.fluss.types.BinaryType;
import org.apache.fluss.types.BooleanType;
import org.apache.fluss.types.BytesType;
import org.apache.fluss.types.CharType;
import org.apache.fluss.types.DataField;
import org.apache.fluss.types.DataTypeVisitor;
import org.apache.fluss.types.DateType;
import org.apache.fluss.types.DecimalType;
import org.apache.fluss.types.DoubleType;
import org.apache.fluss.types.FloatType;
import org.apache.fluss.types.IntType;
import org.apache.fluss.types.LocalZonedTimestampType;
import org.apache.fluss.types.MapType;
import org.apache.fluss.types.RowType;
import org.apache.fluss.types.SmallIntType;
import org.apache.fluss.types.StringType;
import org.apache.fluss.types.TimeType;
import org.apache.fluss.types.TimestampType;
import org.apache.fluss.types.TinyIntType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;

public class FlussDataTypeToPaimonDataType
implements DataTypeVisitor<DataType> {
    public static final FlussDataTypeToPaimonDataType INSTANCE = new FlussDataTypeToPaimonDataType();

    public DataType visit(CharType charType) {
        return this.withNullability(DataTypes.CHAR(charType.getLength()), charType.isNullable());
    }

    public DataType visit(StringType stringType) {
        return this.withNullability(DataTypes.STRING(), stringType.isNullable());
    }

    public DataType visit(BooleanType booleanType) {
        return this.withNullability(DataTypes.BOOLEAN(), booleanType.isNullable());
    }

    public DataType visit(BinaryType binaryType) {
        return this.withNullability(DataTypes.BINARY(binaryType.getLength()), binaryType.isNullable());
    }

    public DataType visit(BytesType bytesType) {
        return this.withNullability(DataTypes.BYTES(), bytesType.isNullable());
    }

    public DataType visit(DecimalType decimalType) {
        return this.withNullability(DataTypes.DECIMAL(decimalType.getPrecision(), decimalType.getScale()), decimalType.isNullable());
    }

    public DataType visit(TinyIntType tinyIntType) {
        return this.withNullability(DataTypes.TINYINT(), tinyIntType.isNullable());
    }

    public DataType visit(SmallIntType smallIntType) {
        return this.withNullability(DataTypes.SMALLINT(), smallIntType.isNullable());
    }

    public DataType visit(IntType intType) {
        return this.withNullability(DataTypes.INT(), intType.isNullable());
    }

    public DataType visit(BigIntType bigIntType) {
        return this.withNullability(DataTypes.BIGINT(), bigIntType.isNullable());
    }

    public DataType visit(FloatType floatType) {
        return this.withNullability(DataTypes.FLOAT(), floatType.isNullable());
    }

    public DataType visit(DoubleType doubleType) {
        return this.withNullability(DataTypes.DOUBLE(), doubleType.isNullable());
    }

    public DataType visit(DateType dateType) {
        return this.withNullability(DataTypes.DATE(), dateType.isNullable());
    }

    public DataType visit(TimeType timeType) {
        return this.withNullability(DataTypes.TIME(), timeType.isNullable());
    }

    public DataType visit(TimestampType timestampType) {
        return this.withNullability(DataTypes.TIMESTAMP(timestampType.getPrecision()), timestampType.isNullable());
    }

    public DataType visit(LocalZonedTimestampType localZonedTimestampType) {
        return this.withNullability(DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE(localZonedTimestampType.getPrecision()), localZonedTimestampType.isNullable());
    }

    public DataType visit(ArrayType arrayType) {
        return this.withNullability(DataTypes.ARRAY((DataType)arrayType.getElementType().accept((DataTypeVisitor)this)), arrayType.isNullable());
    }

    public DataType visit(MapType mapType) {
        return this.withNullability(DataTypes.MAP((DataType)mapType.getKeyType().accept((DataTypeVisitor)this), (DataType)mapType.getValueType().accept((DataTypeVisitor)this)), mapType.isNullable());
    }

    public DataType visit(RowType rowType) {
        RowType.Builder rowTypeBuilder = org.apache.paimon.types.RowType.builder();
        for (DataField field : rowType.getFields()) {
            rowTypeBuilder.field(field.getName(), (DataType)field.getType().accept((DataTypeVisitor)this), field.getDescription().orElse(null));
        }
        return this.withNullability(rowTypeBuilder.build(), rowType.isNullable());
    }

    private DataType withNullability(DataType paimon, boolean nullable) {
        if (paimon.isNullable() != nullable) {
            return nullable ? paimon.nullable() : paimon.notNull();
        }
        return paimon;
    }
}

