/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.tiering;

import org.apache.fluss.lake.paimon.PaimonLakeCatalog;
import org.apache.fluss.lake.paimon.source.FlussRowAsPaimonRow;
import org.apache.fluss.lake.paimon.utils.PaimonConversions;
import org.apache.fluss.record.LogRecord;
import org.apache.fluss.utils.Preconditions;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;

public class FlussRecordAsPaimonRow
extends FlussRowAsPaimonRow {
    private final int bucket;
    private LogRecord logRecord;
    private int originRowFieldCount;

    public FlussRecordAsPaimonRow(int bucket, RowType tableTowType) {
        super(tableTowType);
        this.bucket = bucket;
    }

    public void setFlussRecord(LogRecord logRecord) {
        this.logRecord = logRecord;
        this.internalRow = logRecord.getRow();
        this.originRowFieldCount = this.internalRow.getFieldCount();
        Preconditions.checkState((this.originRowFieldCount == this.tableRowType.getFieldCount() - PaimonLakeCatalog.SYSTEM_COLUMNS.size() ? 1 : 0) != 0, (Object)"The paimon table fields count must equals to LogRecord's fields count.");
    }

    @Override
    public int getFieldCount() {
        return this.originRowFieldCount + PaimonLakeCatalog.SYSTEM_COLUMNS.size();
    }

    @Override
    public RowKind getRowKind() {
        return PaimonConversions.toRowKind(this.logRecord.getChangeType());
    }

    @Override
    public boolean isNullAt(int pos) {
        if (pos < this.originRowFieldCount) {
            return super.isNullAt(pos);
        }
        return false;
    }

    @Override
    public int getInt(int pos) {
        if (pos == this.originRowFieldCount) {
            return this.bucket;
        }
        return super.getInt(pos);
    }

    @Override
    public long getLong(int pos) {
        if (pos == this.originRowFieldCount + 1) {
            return this.logRecord.logOffset();
        }
        if (pos == this.originRowFieldCount + 2) {
            return this.logRecord.timestamp();
        }
        return super.getLong(pos);
    }

    @Override
    public Timestamp getTimestamp(int pos, int precision) {
        if (pos == this.originRowFieldCount + 2) {
            return Timestamp.fromEpochMillis(this.logRecord.timestamp());
        }
        return super.getTimestamp(pos, precision);
    }
}

