/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.fluss.annotation.VisibleForTesting;
import org.apache.fluss.exception.InvalidConfigException;
import org.apache.fluss.exception.InvalidTableException;
import org.apache.fluss.lake.paimon.FlussDataTypeToPaimonDataType;
import org.apache.fluss.lake.paimon.PaimonLakeCatalog;
import org.apache.fluss.lake.paimon.source.FlussRowAsPaimonRow;
import org.apache.fluss.metadata.Schema;
import org.apache.fluss.metadata.TableChange;
import org.apache.fluss.metadata.TableDescriptor;
import org.apache.fluss.metadata.TablePath;
import org.apache.fluss.record.ChangeType;
import org.apache.fluss.row.GenericRow;
import org.apache.fluss.row.InternalRow;
import org.apache.fluss.types.DataTypeVisitor;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;

public class PaimonConversions {
    private static final String FLUSS_CONF_PREFIX = "fluss.";
    private static final String PAIMON_CONF_PREFIX = "paimon.";
    @VisibleForTesting
    public static final Set<String> PAIMON_UNSETTABLE_OPTIONS = new HashSet<String>();

    public static RowKind toRowKind(ChangeType changeType) {
        switch (changeType) {
            case APPEND_ONLY: 
            case INSERT: {
                return RowKind.INSERT;
            }
            case UPDATE_BEFORE: {
                return RowKind.UPDATE_BEFORE;
            }
            case UPDATE_AFTER: {
                return RowKind.UPDATE_AFTER;
            }
            case DELETE: {
                return RowKind.DELETE;
            }
        }
        throw new IllegalArgumentException("Unsupported change type: " + String.valueOf(changeType));
    }

    public static ChangeType toChangeType(RowKind rowKind) {
        switch (rowKind) {
            case INSERT: {
                return ChangeType.INSERT;
            }
            case UPDATE_BEFORE: {
                return ChangeType.UPDATE_BEFORE;
            }
            case UPDATE_AFTER: {
                return ChangeType.UPDATE_AFTER;
            }
            case DELETE: {
                return ChangeType.DELETE;
            }
        }
        throw new IllegalArgumentException("Unsupported rowKind: " + String.valueOf((Object)rowKind));
    }

    public static Identifier toPaimon(TablePath tablePath) {
        return Identifier.create(tablePath.getDatabaseName(), tablePath.getTableName());
    }

    public static Object toPaimonLiteral(DataType dataType, Object flussLiteral) {
        RowType rowType = RowType.of(dataType);
        GenericRow flussRow = GenericRow.of((Object[])new Object[]{flussLiteral});
        FlussRowAsPaimonRow flussRowAsPaimonRow = new FlussRowAsPaimonRow((InternalRow)flussRow, rowType);
        return org.apache.paimon.data.InternalRow.createFieldGetter(dataType, 0).getFieldOrNull(flussRowAsPaimonRow);
    }

    public static List<SchemaChange> toPaimonSchemaChanges(List<TableChange> tableChanges) {
        ArrayList<SchemaChange> schemaChanges = new ArrayList<SchemaChange>(tableChanges.size());
        for (TableChange tableChange : tableChanges) {
            if (tableChange instanceof TableChange.SetOption) {
                TableChange.SetOption setOption = (TableChange.SetOption)tableChange;
                schemaChanges.add(SchemaChange.setOption(PaimonConversions.convertFlussPropertyKeyToPaimon(setOption.getKey()), setOption.getValue()));
                continue;
            }
            if (tableChange instanceof TableChange.ResetOption) {
                TableChange.ResetOption resetOption = (TableChange.ResetOption)tableChange;
                schemaChanges.add(SchemaChange.removeOption(PaimonConversions.convertFlussPropertyKeyToPaimon(resetOption.getKey())));
                continue;
            }
            throw new UnsupportedOperationException("Unsupported table change: " + String.valueOf(tableChange.getClass()));
        }
        return schemaChanges;
    }

    public static Schema toPaimonSchema(TableDescriptor tableDescriptor) {
        PaimonConversions.validatePaimonOptions(tableDescriptor.getProperties());
        PaimonConversions.validatePaimonOptions(tableDescriptor.getCustomProperties());
        Schema.Builder schemaBuilder = Schema.newBuilder();
        Options options = new Options();
        PaimonConversions.setPaimonDefaultProperties(options);
        List bucketKeys = tableDescriptor.getBucketKeys();
        if (!bucketKeys.isEmpty()) {
            int numBuckets = (Integer)tableDescriptor.getTableDistribution().flatMap(TableDescriptor.TableDistribution::getBucketCount).orElseThrow(() -> new IllegalArgumentException("Bucket count should be set."));
            options.set(CoreOptions.BUCKET, numBuckets);
            options.set(CoreOptions.BUCKET_KEY, String.join((CharSequence)",", bucketKeys));
        } else {
            options.set(CoreOptions.BUCKET, CoreOptions.BUCKET.defaultValue());
        }
        for (Schema.Column column : tableDescriptor.getSchema().getColumns()) {
            String columnName = column.getName();
            if (PaimonLakeCatalog.SYSTEM_COLUMNS.containsKey(columnName)) {
                throw new InvalidTableException("Column " + columnName + " conflicts with a system column name of paimon table, please rename the column.");
            }
            schemaBuilder.column(columnName, (DataType)column.getDataType().accept((DataTypeVisitor)FlussDataTypeToPaimonDataType.INSTANCE), column.getComment().orElse(null));
        }
        for (Map.Entry entry : PaimonLakeCatalog.SYSTEM_COLUMNS.entrySet()) {
            schemaBuilder.column((String)entry.getKey(), (DataType)entry.getValue());
        }
        if (tableDescriptor.hasPrimaryKey()) {
            schemaBuilder.primaryKey(((Schema.PrimaryKey)tableDescriptor.getSchema().getPrimaryKey().get()).getColumnNames());
            options.set(CoreOptions.CHANGELOG_PRODUCER.key(), CoreOptions.ChangelogProducer.INPUT.toString());
        }
        schemaBuilder.partitionKeys(tableDescriptor.getPartitionKeys());
        tableDescriptor.getProperties().forEach((k, v) -> PaimonConversions.setFlussPropertyToPaimon(k, v, options));
        tableDescriptor.getCustomProperties().forEach((k, v) -> PaimonConversions.setFlussPropertyToPaimon(k, v, options));
        schemaBuilder.options(options.toMap());
        return schemaBuilder.build();
    }

    private static void validatePaimonOptions(Map<String, String> properties) {
        properties.forEach((k, v) -> {
            String paimonKey = k;
            if (k.startsWith(PAIMON_CONF_PREFIX)) {
                paimonKey = k.substring(PAIMON_CONF_PREFIX.length());
            }
            if (PAIMON_UNSETTABLE_OPTIONS.contains(paimonKey)) {
                throw new InvalidConfigException(String.format("The Paimon option %s will be set automatically by Fluss and should not be set manually.", k));
            }
        });
    }

    private static void setPaimonDefaultProperties(Options options) {
        options.set(CoreOptions.PARTITION_GENERATE_LEGCY_NAME, false);
    }

    private static void setFlussPropertyToPaimon(String key, String value, Options options) {
        if (key.startsWith(PAIMON_CONF_PREFIX)) {
            options.set(key.substring(PAIMON_CONF_PREFIX.length()), value);
        } else {
            options.set(FLUSS_CONF_PREFIX + key, value);
        }
    }

    private static String convertFlussPropertyKeyToPaimon(String key) {
        if (key.startsWith(PAIMON_CONF_PREFIX)) {
            return key.substring(PAIMON_CONF_PREFIX.length());
        }
        return FLUSS_CONF_PREFIX + key;
    }

    static {
        PAIMON_UNSETTABLE_OPTIONS.add(CoreOptions.BUCKET.key());
        PAIMON_UNSETTABLE_OPTIONS.add(CoreOptions.BUCKET_KEY.key());
        PAIMON_UNSETTABLE_OPTIONS.add(CoreOptions.PARTITION_GENERATE_LEGCY_NAME.key());
    }
}

