/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.util.LinkedList;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.mergetree.compact.FirstRowMergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;

public class LookupMergeFunction
implements MergeFunction<KeyValue> {
    private final MergeFunction<KeyValue> mergeFunction;
    private final LinkedList<KeyValue> candidates = new LinkedList();

    public LookupMergeFunction(MergeFunction<KeyValue> mergeFunction) {
        this.mergeFunction = mergeFunction;
    }

    @Override
    public void reset() {
        this.candidates.clear();
    }

    @Override
    public void add(KeyValue kv) {
        this.candidates.add(kv);
    }

    @Nullable
    public KeyValue pickHighLevel() {
        KeyValue highLevel = null;
        for (KeyValue kv : this.candidates) {
            if (kv.level() <= 0 || highLevel != null && kv.level() >= highLevel.level()) continue;
            highLevel = kv;
        }
        return highLevel;
    }

    public InternalRow key() {
        return this.candidates.get(0).key();
    }

    public LinkedList<KeyValue> candidates() {
        return this.candidates;
    }

    @Override
    public KeyValue getResult() {
        this.mergeFunction.reset();
        KeyValue highLevel = this.pickHighLevel();
        for (KeyValue kv : this.candidates) {
            if (kv.level() > 0 && kv != highLevel) continue;
            this.mergeFunction.add(kv);
        }
        return this.mergeFunction.getResult();
    }

    @Override
    public boolean requireCopy() {
        return true;
    }

    public static MergeFunctionFactory<KeyValue> wrap(MergeFunctionFactory<KeyValue> wrapped) {
        if (wrapped.create() instanceof FirstRowMergeFunction) {
            return wrapped;
        }
        return new Factory(wrapped);
    }

    private static class Factory
    implements MergeFunctionFactory<KeyValue> {
        private static final long serialVersionUID = 1L;
        private final MergeFunctionFactory<KeyValue> wrapped;

        private Factory(MergeFunctionFactory<KeyValue> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public MergeFunction<KeyValue> create(@Nullable int[][] projection) {
            return new LookupMergeFunction(this.wrapped.create(projection));
        }

        @Override
        public MergeFunctionFactory.AdjustedProjection adjustProjection(@Nullable int[][] projection) {
            return this.wrapped.adjustProjection(projection);
        }
    }
}

