/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.util;

import com.nimbusds.jose.util.Base64Codec;
import com.nimbusds.jose.util.BigIntegerUtils;
import java.math.BigInteger;
import java.nio.charset.Charset;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONValue;

@Immutable
public class Base64
implements JSONAware {
    public static final Charset CHARSET = Charset.forName("UTF-8");
    private final String value;

    public Base64(String base64) {
        if (base64 == null) {
            throw new IllegalArgumentException("The Base64 value must not be null");
        }
        this.value = base64;
    }

    public byte[] decode() {
        return Base64Codec.decode(this.value);
    }

    public BigInteger decodeToBigInteger() {
        return new BigInteger(1, this.decode());
    }

    public String decodeToString() {
        return new String(this.decode(), CHARSET);
    }

    @Override
    public String toJSONString() {
        return "\"" + JSONValue.escape(this.value) + "\"";
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Base64 && this.toString().equals(object.toString());
    }

    public static Base64 encode(byte[] bytes) {
        return new Base64(Base64Codec.encodeToString(bytes, false));
    }

    public static Base64 encode(BigInteger bigInt) {
        return Base64.encode(BigIntegerUtils.toBytesUnsigned(bigInt));
    }

    public static Base64 encode(String text) {
        return Base64.encode(text.getBytes(CHARSET));
    }
}

