/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptStarted;
import org.apache.hadoop.yarn.api.records.ContainerId;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TaskAttemptStartedEvent
implements HistoryEvent {
    private TaskAttemptStarted datum = new TaskAttemptStarted();

    public TaskAttemptStartedEvent(TaskAttemptID attemptId, TaskType taskType, long startTime, String trackerName, int httpPort, int shufflePort, ContainerId containerId, String locality, String avataar) {
        this.datum.setAttemptId(new Utf8(attemptId.toString()));
        this.datum.setTaskid(new Utf8(attemptId.getTaskID().toString()));
        this.datum.setStartTime(startTime);
        this.datum.setTaskType(new Utf8(taskType.name()));
        this.datum.setTrackerName(new Utf8(trackerName));
        this.datum.setHttpPort(httpPort);
        this.datum.setShufflePort(shufflePort);
        this.datum.setContainerId(new Utf8(containerId.toString()));
        if (locality != null) {
            this.datum.setLocality(new Utf8(locality));
        }
        if (avataar != null) {
            this.datum.setAvataar(new Utf8(avataar));
        }
    }

    public TaskAttemptStartedEvent(TaskAttemptID attemptId, TaskType taskType, long startTime, String trackerName, int httpPort, int shufflePort, String locality, String avataar) {
        this(attemptId, taskType, startTime, trackerName, httpPort, shufflePort, ContainerId.fromString("container_-1_-1_-1_-1"), locality, avataar);
    }

    TaskAttemptStartedEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (TaskAttemptStarted)datum;
    }

    public TaskID getTaskId() {
        return TaskID.forName(this.datum.getTaskid().toString());
    }

    public String getTrackerName() {
        return this.datum.getTrackerName().toString();
    }

    public long getStartTime() {
        return this.datum.getStartTime();
    }

    public TaskType getTaskType() {
        return TaskType.valueOf(this.datum.getTaskType().toString());
    }

    public int getHttpPort() {
        return this.datum.getHttpPort();
    }

    public int getShufflePort() {
        return this.datum.getShufflePort();
    }

    public TaskAttemptID getTaskAttemptId() {
        return TaskAttemptID.forName(this.datum.getAttemptId().toString());
    }

    @Override
    public EventType getEventType() {
        return this.getTaskId().getTaskType() == TaskType.MAP ? EventType.MAP_ATTEMPT_STARTED : EventType.REDUCE_ATTEMPT_STARTED;
    }

    public ContainerId getContainerId() {
        return ContainerId.fromString(this.datum.getContainerId().toString());
    }

    public String getLocality() {
        if (this.datum.getLocality() != null) {
            return this.datum.getLocality().toString();
        }
        return null;
    }

    public String getAvataar() {
        if (this.datum.getAvataar() != null) {
            return this.datum.getAvataar().toString();
        }
        return null;
    }
}

